/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.util.Enumeration;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.number.PdVector_IP;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwMarkWithSphere
extends PjWorkshop
implements PvPickListenerIf {
    protected PuDouble m_Radius = new PuDouble(PsConfig.getMessage((int)54308), (PsUpdateIf)this);
    protected PdVector m_centerOfSphere;
    protected PdVector_IP m_center_IP;
    protected boolean m_bInvertMarks;
    protected boolean m_bMarkElem;
    protected boolean m_bAddToSelection;
    protected PgPointSet m_geom;
    protected PgPolygon m_circle;
    protected int m_numVertOfCircle;
    protected PdVector m_normal;
    protected boolean m_bVisCircle;
    protected int m_numOfAverages;
    protected PdVector[] m_listOfNormals;
    protected int m_currNormalsInd;
    private PdVector[] e;
    static /* synthetic */ Class class$jvx$geom$PwMarkWithSphere;

    public PwMarkWithSphere() {
        super(PsConfig.getMessage((int)48017));
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwMarkWithSphere == null ? (class$jvx$geom$PwMarkWithSphere = PwMarkWithSphere.class$("jvx.geom.PwMarkWithSphere")) : class$jvx$geom$PwMarkWithSphere)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bVisCircle = false;
        this.m_Radius.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_Radius.setDefValue(1.0);
        this.m_Radius.init();
        this.m_bInvertMarks = false;
        this.m_bMarkElem = false;
        this.m_bAddToSelection = false;
        this.m_centerOfSphere = new PdVector();
        this.m_center_IP = new PdVector_IP();
        this.m_center_IP.setParent((PsUpdateIf)this);
        this.m_center_IP.setTitle(PsConfig.getMessage((int)48018));
        this.m_circle = new PgPolygon(3);
        this.m_numVertOfCircle = 32;
        this.m_circle.setNumVertices(this.m_numVertOfCircle);
        this.m_circle.setClosed(true);
        this.m_circle.showVertices(false);
        this.m_circle.setName(PsConfig.getMessage((int)45057));
        this.m_numOfAverages = 10;
        this.m_currNormalsInd = 0;
        this.m_listOfNormals = PdVector.realloc(null, (int)this.m_numOfAverages, (int)0);
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        super.setDisplay(pvDisplayIf);
        if (this.m_display != null) {
            this.m_display.addPickListener((PvPickListenerIf)this);
            this.m_normal = this.m_display.getCamera().getViewDir();
        }
    }

    public void setGeometry(PgPointSet pgPointSet) {
        this.m_geom = pgPointSet;
        this.m_centerOfSphere.setSize(3);
        this.m_centerOfSphere.copyArray(this.m_geom.getVertex((int)((double)pgPointSet.getNumVertices() * Math.random())));
        this.m_center_IP.setVector(this.m_centerOfSphere);
        this.m_displayList = this.m_geom.getDisplayList();
        Enumeration enumeration = this.m_displayList.elements();
        while (enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            pvDisplayIf.addGeometry((PgGeometryIf)this.m_circle);
        }
        double d = this.m_geom.getDiameter();
        this.m_Radius.setBounds(0.0, d, d / 100.0, d / 10.0);
        this.m_Radius.setValue(d / 4.0);
        this.m_Radius.update((Object)this.m_Radius);
        int n = pgPointSet.getDimOfVertices();
        for (int i = 0; i < this.m_numOfAverages; ++i) {
            this.m_listOfNormals[i].setSize(n);
        }
    }

    public boolean update(Object object) {
        if (object == this.m_Radius) {
            this.markVertices();
            this.computeCircle(this.m_normal, this.m_numVertOfCircle);
            this.m_circle.update((Object)this.m_circle);
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        if (object == this.m_center_IP) {
            this.markVertices();
            this.m_normal = this.m_display != null ? this.m_display.getCamera().getViewDir() : new PdVector(0.0, 0.0, 1.0);
            this.computeCircle(this.m_normal, this.m_numVertOfCircle);
            this.m_circle.update((Object)this.m_circle);
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        return super.update(object);
    }

    public void cancel() {
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        for (int i = 0; i < n; ++i) {
            pdVectorArray[i].clearTag(1);
        }
        this.markElementsFromVertices();
        this.m_geom.update((Object)this.m_geom);
        this.close();
    }

    public void close() {
        this.m_display.removePickListener((PvPickListenerIf)this);
        Enumeration enumeration = this.m_displayList.elements();
        while (enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            pvDisplayIf.removeGeometry((PgGeometryIf)this.m_circle);
            pvDisplayIf.update((Object)pvDisplayIf);
        }
        super.close();
    }

    public void markVertices() {
        int n = this.m_geom.getNumVertices();
        int n2 = this.m_geom.getDimOfVertices();
        double d = this.m_Radius.getValue();
        d *= d;
        double d2 = 0.0;
        if (this.m_bInvertMarks) {
            this.invertMarks();
        }
        for (int i = 0; i < n; ++i) {
            PdVector pdVector = this.m_geom.getVertex(i);
            if (!this.m_bAddToSelection) {
                pdVector.clearTag(1);
            } else if (pdVector.hasTag(1)) continue;
            for (int j = 0; j < n2; ++j) {
                d2 += (pdVector.m_data[j] - this.m_centerOfSphere.m_data[j]) * (pdVector.m_data[j] - this.m_centerOfSphere.m_data[j]);
            }
            if (d2 <= d) {
                pdVector.setTag(1);
            }
            d2 = 0.0;
        }
        if (this.m_bInvertMarks) {
            this.invertMarks();
        }
        if (this.m_bMarkElem) {
            this.markElementsFromVertices();
        }
    }

    protected void invertMarks() {
        int n = this.m_geom.getNumVertices();
        for (int i = 0; i < n; ++i) {
            PdVector pdVector = this.m_geom.getVertex(i);
            if (pdVector.hasTag(1)) {
                pdVector.clearTag(1);
                continue;
            }
            pdVector.setTag(1);
        }
    }

    protected void markElementsFromVertices() {
        if (this.m_geom instanceof PgElementSet) {
            PgElementSet pgElementSet = (PgElementSet)this.m_geom;
            int n = pgElementSet.getNumElements();
            boolean bl = true;
            PiVector[] piVectorArray = pgElementSet.getElements();
            PdVector[] pdVectorArray = pgElementSet.getVertices();
            for (int i = 0; i < n; ++i) {
                int n2 = piVectorArray[i].getSize();
                for (int j = 0; j < n2; ++j) {
                    if (pdVectorArray[piVectorArray[i].m_data[j]].hasTag(1)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    piVectorArray[i].setTag(1);
                    continue;
                }
                piVectorArray[i].clearTag(1);
                bl = true;
            }
        } else if (this.m_geom instanceof PgPolygonSet) {
            PgPolygonSet pgPolygonSet = (PgPolygonSet)this.m_geom;
            int n = pgPolygonSet.getNumPolygons();
            boolean bl = true;
            PiVector[] piVectorArray = pgPolygonSet.getPolygons();
            PdVector[] pdVectorArray = pgPolygonSet.getVertices();
            for (int i = 0; i < n; ++i) {
                int n3 = piVectorArray[i].getSize();
                for (int j = 0; j < n3; ++j) {
                    if (pdVectorArray[piVectorArray[i].m_data[j]].hasTag(1)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    piVectorArray[i].setTag(1);
                    continue;
                }
                piVectorArray[i].clearTag(1);
                bl = true;
            }
        } else if (this.m_geom instanceof PgPolygon) {
            PgPolygon pgPolygon = (PgPolygon)this.m_geom;
            int n = pgPolygon.getNumEdges();
            PiVector[] piVectorArray = pgPolygon.getEdges();
            PdVector[] pdVectorArray = pgPolygon.getVertices();
            for (int i = 0; i < n; ++i) {
                if (piVectorArray[i] == null || piVectorArray[i].getSize() < 2) continue;
                if (pdVectorArray[piVectorArray[i].m_data[0]].hasTag(1) && pdVectorArray[piVectorArray[i].m_data[1]].hasTag(1)) {
                    piVectorArray[i].setTag(1);
                    continue;
                }
                piVectorArray[i].clearTag(1);
            }
        } else {
            PsDebug.warning((String)("Cannot mark Elements/Polygons " + this.m_geom.getName() + " " + "is not a PgElementSet, PgPolygonSet or PgPolygon."));
            return;
        }
    }

    protected void computeCircle(PdVector pdVector, int n) {
        if (pdVector == null || pdVector.getSize() != 3) {
            pdVector = new PdVector(0.0, 0.0, 1.0);
        }
        if (pdVector.length() < 1.0E-10) {
            this.m_circle.setNumVertices(0);
            this.m_circle.update((Object)this.m_circle);
            return;
        }
        PdVector pdVector2 = PdVector.normalToVectorNew((PdVector)pdVector);
        PdVector pdVector3 = PdVector.crossNew((PdVector)pdVector, (PdVector)pdVector2);
        double d = this.m_Radius.getValue();
        pdVector2.setLength(d);
        pdVector3.setLength(d);
        double d2 = Math.PI * 2 / (double)n;
        if (this.m_bVisCircle) {
            if (this.m_circle.getNumVertices() != n) {
                this.m_circle.setNumVertices(n);
            }
            PdVector[] pdVectorArray = this.m_circle.getVertices();
            for (int i = 0; i < n; ++i) {
                pdVectorArray[i].blend(Math.cos(d2 * (double)i), pdVector2, Math.sin(d2 * (double)i), pdVector3);
                pdVectorArray[i].add(this.m_centerOfSphere);
            }
        } else {
            int n2;
            if (this.m_circle.getNumVertices() != 3 * n) {
                this.m_circle.setNumVertices(3 * n);
            }
            PdVector[] pdVectorArray = this.m_circle.getVertices();
            PdVector pdVector4 = (PdVector)pdVector.clone();
            pdVector4.setLength(d);
            int n3 = n / 4;
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                pdVectorArray[n4].blend(Math.cos(d2 * (double)n2), pdVector2, Math.sin(d2 * (double)n2), pdVector3);
                pdVectorArray[n4++].add(this.m_centerOfSphere);
            }
            for (n2 = 0; n2 < n; ++n2) {
                pdVectorArray[n4].blend(Math.cos(d2 * (double)n2), pdVector3, Math.sin(d2 * (double)n2), pdVector4);
                pdVectorArray[n4++].add(this.m_centerOfSphere);
            }
            for (n2 = n3; n2 < n; ++n2) {
                pdVectorArray[n4].blend(Math.cos(d2 * (double)n2), pdVector2, Math.sin(d2 * (double)n2), pdVector3);
                pdVectorArray[n4++].add(this.m_centerOfSphere);
            }
            for (n2 = 0; n2 < n; ++n2) {
                pdVectorArray[n4].blend(Math.cos(d2 * (double)n2), pdVector2, Math.sin(d2 * (double)n2), pdVector4);
                pdVectorArray[n4++].add(this.m_centerOfSphere);
            }
        }
    }

    protected void computeSphere(PdVector pdVector, int n) {
        int n2;
        if (this.m_circle.getNumVertices() != 3 * n) {
            this.m_circle.setNumVertices(3 * n);
        }
        if (this.e == null) {
            this.e = PdVector.realloc(null, (int)3, (int)this.m_geom.getDimOfVertices());
        }
        double d = this.m_Radius.getValue();
        this.e[0].copyArray(pdVector);
        this.e[0].setLength(d);
        this.e[1].normalToVector(pdVector);
        this.e[1].setLength(d);
        this.e[2].cross(this.e[0], this.e[1]);
        this.e[2].setLength(d);
        double d2 = Math.PI * 2 / (double)n;
        PdVector[] pdVectorArray = this.m_circle.getVertices();
        int n3 = n / 4;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            pdVectorArray[n4].blend(Math.cos(d2 * (double)n2), this.e[1], Math.sin(d2 * (double)n2), this.e[2]);
            pdVectorArray[n4++].add(this.m_centerOfSphere);
        }
        for (n2 = 0; n2 < n; ++n2) {
            pdVectorArray[n4].blend(Math.cos(d2 * (double)n2), this.e[2], Math.sin(d2 * (double)n2), this.e[0]);
            pdVectorArray[n4++].add(this.m_centerOfSphere);
        }
        for (n2 = n3; n2 < n; ++n2) {
            pdVectorArray[n4].blend(Math.cos(d2 * (double)n2), this.e[1], Math.sin(d2 * (double)n2), this.e[2]);
            pdVectorArray[n4++].add(this.m_centerOfSphere);
        }
        for (n2 = 0; n2 < n; ++n2) {
            pdVectorArray[n4].blend(Math.cos(d2 * (double)n2), this.e[1], Math.sin(d2 * (double)n2), this.e[0]);
            pdVectorArray[n4++].add(this.m_centerOfSphere);
        }
    }

    protected static void removeMarks(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (int i = 0; i < n; ++i) {
            piVectorArray[i].clearTag(1);
        }
    }

    public void setRadius(double d) {
        this.m_Radius.setValue(d);
        this.m_Radius.updatePanels((Object)this.m_Radius);
    }

    public void setCenter(PdVector pdVector) {
        this.m_centerOfSphere.m_data[0] = pdVector.m_data[0];
        this.m_centerOfSphere.m_data[1] = pdVector.m_data[1];
        this.m_centerOfSphere.m_data[2] = pdVector.m_data[2];
        this.m_center_IP.update((Object)this.m_centerOfSphere);
    }

    public void setInvertMarks(boolean bl) {
        this.m_bInvertMarks = bl;
    }

    public void setMarkElements(boolean bl) {
    }

    public String getName() {
        return this.getName();
    }

    public void selectGeometry(PgGeometryIf pgGeometryIf) {
    }

    public void pickDisplay(PvPickEvent pvPickEvent) {
    }

    public void dragDisplay(PvPickEvent pvPickEvent) {
        this.pickDisplay(pvPickEvent);
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        int n;
        PgGeometryIf pgGeometryIf = pvPickEvent.getGeometry();
        if (pgGeometryIf == this.m_circle) {
            return;
        }
        if (pgGeometryIf != null && pgGeometryIf instanceof PgPointSet) {
            this.m_geom = (PgPointSet)pgGeometryIf;
        }
        int n2 = this.m_centerOfSphere.getSize();
        int n3 = this.m_geom.getDimOfVertices();
        PdVector pdVector = pvPickEvent.getVertex();
        if (pdVector.getSize() < n2) {
            int n4;
            n = pdVector.getSize();
            for (n4 = 0; n4 < n; ++n4) {
                this.m_centerOfSphere.m_data[n4] = pdVector.m_data[n4];
            }
            for (n4 = n; n4 < n2; ++n4) {
                this.m_centerOfSphere.m_data[n4] = 0.0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.m_centerOfSphere.m_data[n] = pdVector.m_data[n];
            }
        }
        this.m_center_IP.update((Object)this.m_centerOfSphere);
        this.markVertices();
        PgElementSet pgElementSet = null;
        if (this.m_geom instanceof PgElementSet && n3 == 3) {
            pgElementSet = (PgElementSet)this.m_geom;
        }
        if (pgElementSet != null && pgElementSet.getNeighbours() != null && pgElementSet.hasElementNormals()) {
            PiVector piVector = pgElementSet.getNeighbour(pvPickEvent.getElementInd());
            this.m_normal = pvPickEvent.getNormal();
            int n5 = piVector.getSize();
            for (int i = 0; i < n5; ++i) {
                PdVector pdVector2 = pgElementSet.getElementNormal(piVector.m_data[i]);
                if (pdVector2 == null) continue;
                this.m_normal.add(pdVector2);
            }
            this.m_normal.normalize();
        } else {
            this.m_normal = null;
            this.m_normal = this.m_display != null ? this.m_display.getCamera().getViewDir() : pvPickEvent.getNormal();
            if (this.m_normal == null || this.m_normal.length() < 1.0E-10 || this.m_normal.getSize() < 3) {
                this.m_normal = new PdVector(0.0, 0.0, 1.0);
            }
        }
        this.m_listOfNormals[this.m_currNormalsInd].copyArray(this.m_normal);
        int n6 = (this.m_currNormalsInd + 1) % this.m_numOfAverages;
        while (n6 != this.m_currNormalsInd) {
            this.m_normal.add(this.m_listOfNormals[n6]);
            n6 = (n6 + 1) % this.m_numOfAverages;
        }
        this.m_currNormalsInd = (this.m_currNormalsInd + 1) % this.m_numOfAverages;
        this.m_normal.normalize();
        this.computeCircle(this.m_normal, this.m_numVertOfCircle);
        this.m_circle.update((Object)this.m_circle);
        this.m_geom.update((Object)this.m_geom);
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public void pickVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void dragVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void markVertices(PvPickEvent pvPickEvent) {
    }

    public void unmarkVertices(PvPickEvent pvPickEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

