/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jvx.geom.PnEvolve;
import jvx.project.PjWorkshop;

public class PwEvolve
extends PjWorkshop
implements PsTimeListenerIf {
    protected int m_types = 0;
    protected PsAnimation m_anim;
    protected PgPointSet m_pointSet;
    protected PgElementSet m_elemSet;
    protected int m_direction;
    protected boolean m_bFlipDirection;
    protected boolean m_bUpdateNormals;
    protected PuDouble m_offsetFactor = new PuDouble(PsConfig.getMessage((int)54009), (PsUpdateIf)this);
    protected double m_offsetSave;
    static /* synthetic */ Class class$jvx$geom$PwEvolve;

    public PwEvolve() {
        super(PsConfig.getMessage((int)54291));
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwEvolve == null ? (class$jvx$geom$PwEvolve = PwEvolve.class$("jvx.geom.PwEvolve")) : class$jvx$geom$PwEvolve)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bFlipDirection = false;
        this.m_bUpdateNormals = false;
        this.m_direction = 2;
        this.m_offsetFactor.setDefBounds(-5.0, 5.0, 0.01, 0.1);
        this.m_offsetFactor.setDefValue(0.0);
        this.m_offsetFactor.init();
        this.m_offsetSave = this.m_offsetFactor.getValue();
    }

    public void reset() {
        super.reset();
        if (this.m_pointSet != null && this.m_geomSave != null) {
            this.m_pointSet.copy((PsObject)this.m_geomSave);
        }
    }

    public boolean update(Object object) {
        if (object == this.m_pointSet) {
            if (this.isUpdateSender()) {
                return true;
            }
            if (this.isModal()) {
                return true;
            }
            this.setGeometry(this.m_pointSet);
            this.compute();
            return true;
        }
        if (object == this) {
            return super.update((Object)this);
        }
        if (object == this.m_offsetFactor) {
            if (this.m_anim != null) {
                this.m_anim.setTimeInterval(this.m_offsetFactor.getMin(), this.m_offsetFactor.getMax(), this.m_offsetFactor.getLineIncr(), this.m_offsetFactor.getPageIncr());
                this.m_anim.setTime(this.m_offsetFactor.getValue());
            }
            this.compute();
            return super.update(null);
        }
        return super.update(object);
    }

    public void setGeometry(PgPointSet pgPointSet) {
        super.setGeometry((PgGeometry)pgPointSet);
        this.m_pointSet = pgPointSet;
        if (this.m_types == 0) {
            if (this.m_pointSet.hasVertexNormals()) {
                this.m_types += 2;
            }
            if (this.m_pointSet.getVectorField(0) != null) {
                this.m_types += 4;
            }
        }
        this.m_elemSet = pgPointSet instanceof PgElementSet ? (PgElementSet)pgPointSet : null;
    }

    public void close() {
        if (this.m_anim != null && this.m_anim.isRunning()) {
            this.stop();
            this.m_anim.removeTimeListener((PsTimeListenerIf)this);
            this.m_anim = null;
        }
        super.close();
    }

    public boolean isEnabledFlip() {
        return this.m_bFlipDirection;
    }

    public void setEnabledFlip(boolean bl) {
        this.m_bFlipDirection = bl;
    }

    public boolean isEnabledUpdateNormals() {
        return this.m_bUpdateNormals;
    }

    public void setEnabledUpdateNormals(boolean bl) {
        this.m_bUpdateNormals = bl;
    }

    public int getDirection() {
        return this.m_direction;
    }

    public int setDirection(int n) {
        if (n < 0) {
            PsDebug.warning((String)("void direction = " + n));
            return -1;
        }
        this.m_direction = n;
        return n;
    }

    public double getOffsetFactor() {
        return this.m_offsetFactor.getValue();
    }

    public void setOffsetFactor(double d) {
        this.m_offsetFactor.setValue(d);
        this.m_offsetSave = 0.0;
    }

    public void compute() {
        if (this.m_pointSet == null) {
            PsDebug.warning((String)"missing geometry.");
            return;
        }
        double d = this.m_offsetFactor.getValue() - this.m_offsetSave;
        this.m_offsetSave = this.m_offsetFactor.getValue();
        if (this.m_bFlipDirection) {
            d = -d;
        }
        switch (this.m_direction) {
            case 2: {
                PnEvolve.evolveParallel(this.m_pointSet, d);
                break;
            }
            case 4: {
                PnEvolve.evolveVectorField(this.m_pointSet, d);
                break;
            }
            case 8: {
                PnEvolve.evolveParallel(this.m_pointSet, d);
                break;
            }
            case 16: {
                PnEvolve.evolveParallel(this.m_pointSet, d);
            }
        }
        if (this.m_bUpdateNormals && this.m_pointSet.hasVertexNormals()) {
            this.m_pointSet.makeVertexNormals();
        }
        if (this.m_bUpdateNormals && this.m_elemSet != null && this.m_elemSet.hasElementNormals()) {
            this.m_elemSet.makeElementNormals();
        }
        this.setUpdateSender(true);
        this.m_pointSet.update((Object)this.m_pointSet);
        this.setUpdateSender(false);
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        this.m_offsetFactor.setValue(psTimeEvent.getTime());
        this.compute();
        return true;
    }

    public void start() {
        if (this.m_anim == null) {
            this.m_anim = new PsAnimation();
            this.m_anim.setName(PsConfig.getMessage((int)45001));
            this.m_anim.setTimeInterval(this.m_offsetFactor.getMin(), this.m_offsetFactor.getMax(), this.m_offsetFactor.getLineIncr(), this.m_offsetFactor.getPageIncr());
            this.m_anim.setTime(this.m_offsetFactor.getValue());
            this.m_anim.addTimeListener((PsTimeListenerIf)this);
        }
        this.m_anim.start();
    }

    public void stop() {
        if (this.m_anim == null) {
            return;
        }
        if (this.m_anim.hasAnimationPanel()) {
            this.m_anim.getAnimationPanel().setVisible(false);
        }
        this.m_anim.stop();
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public boolean hasAnimation() {
        return this.m_anim != null;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_anim = psAnimation;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

