/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgUtil;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnJacobi;
import jvx.numeric.PnMassMatrix;

public class PwCurvature
extends PsObject {
    public static void makeColorFromGaussCurvature(PgElementSet pgElementSet) {
        pgElementSet.assureElementColors();
        pgElementSet.assureVertexColors();
        PdVector pdVector = new PdVector(pgElementSet.getNumVertices());
        PwCurvature.getGaussCurvature(pgElementSet, pdVector);
        double d = pdVector.max();
        double d2 = pdVector.min();
        double d3 = 255.0;
        if (d - d2 > 1.0E-10) {
            d3 = 255.0 / (d - d2);
        }
        double[] dArray = pdVector.m_data;
        for (int i = pgElementSet.getNumVertices() - 1; i >= 0; --i) {
            pgElementSet.setVertexColor(i, PdColor.hsv2rgb((int)((int)((dArray[i] - d2) * d3)), (int)255, (int)255));
        }
        pgElementSet.makeElementFromVertexColors();
    }

    public static double getGaussCurvature(PgElementSet pgElementSet, PdVector pdVector) {
        int n;
        int n2;
        int n3;
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing element set.");
            return 0.0;
        }
        int n4 = pgElementSet.getNumElements();
        int n5 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        if (pdVector == null) {
            pdVector = new PdVector(n5);
        } else {
            if (pdVector.getSize() != n5) {
                pdVector.setSize(n5);
            }
            pdVector.setConstant(0.0);
        }
        double[] dArray = pdVector.m_data;
        for (n3 = 0; n3 < n5; ++n3) {
            pdVectorArray[n3].clearTag(0);
        }
        double[] dArray2 = new double[3];
        for (n3 = 0; n3 < n4; ++n3) {
            int n6;
            n2 = piVectorArray[n3].getSize();
            for (n = 0; n < n2; ++n) {
                pdVectorArray[piVectorArray[n3].m_data[n]].setTag(0);
            }
            PdVector[] pdVectorArray2 = pgElementSet.getElementVertices(n3);
            if (n2 > 3) {
                PiVector[] piVectorArray3 = PgUtil.triangulate((PdVector[])pdVectorArray2, (int)n2);
                for (n = 0; n < n2 - 2; ++n) {
                    PdVector.angle((double[])dArray2, (PdVector)pdVectorArray2[piVectorArray3[n].m_data[0]], (PdVector)pdVectorArray2[piVectorArray3[n].m_data[1]], (PdVector)pdVectorArray2[piVectorArray3[n].m_data[2]]);
                    for (n6 = 0; n6 < 3; ++n6) {
                        int n7 = piVectorArray[n3].m_data[piVectorArray3[n].m_data[n6]];
                        dArray[n7] = dArray[n7] + dArray2[n6];
                    }
                }
                continue;
            }
            if (n2 != 3) continue;
            PdVector.angle((double[])dArray2, (PdVector[])pdVectorArray2);
            for (n6 = 0; n6 < 3; ++n6) {
                int n8 = piVectorArray[n3].m_data[n6];
                dArray[n8] = dArray[n8] + dArray2[n6];
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = piVectorArray[n3].m_data.length;
            for (n = 0; n < n2; ++n) {
                if (piVectorArray2[n3].m_data[n] != -1) continue;
                pdVectorArray[piVectorArray[n3].m_data[(n + 1) % n2]].clearTag(0);
                pdVectorArray[piVectorArray[n3].m_data[(n + 2) % n2]].clearTag(0);
            }
        }
        double d = 0.0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (pdVectorArray[n3].hasTag(0)) {
                pdVector.m_data[n3] = Math.PI * 2 - dArray[n3];
                d += pdVector.m_data[n3];
                continue;
            }
            pdVector.m_data[n3] = 0.0;
        }
        return d;
    }

    public static double getGaussCurvature(PgElementSet pgElementSet, int n, int n2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing element set.");
            return 0.0;
        }
        if (n < 0 || n >= pgElementSet.getNumVertices()) {
            PsDebug.warning((String)"Vertex index out of range.");
            return 0.0;
        }
        if (n2 < -1 || n2 >= pgElementSet.getNumElements()) {
            PsDebug.message((String)"Element index out of range, using -1.");
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, n, n2);
        if (!pgVertexStar.isClosed()) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < pgVertexStar.getSize(); ++i) {
            int n3 = pgVertexStar.getElement().getEntry(i);
            int n4 = pgElementSet.getDimOfElement(n3);
            if (n4 == 3) {
                d += PdVector.angle((PdVector)pgElementSet.getVertex(n), (PdVector)pgElementSet.getVertex(pgVertexStar.getLink().getEntry(i)), (PdVector)pgElementSet.getVertex(pgVertexStar.getLink().getEntry((i + 1) % pgVertexStar.getSize()))) * Math.PI / 180.0;
            }
            if (n4 <= 3) continue;
            PdVector[] pdVectorArray = pgElementSet.getElementVertices(n3);
            PiVector[] piVectorArray = PgUtil.triangulate((PdVector[])pdVectorArray, (int)n4);
            for (int j = 0; j < n4 - 2; ++j) {
                int n5 = piVectorArray[j].getIndexOf(pgVertexStar.getVertexLocInd().getEntry(i));
                if (n5 < 0) continue;
                d += PdVector.angle((PdVector)pdVectorArray[piVectorArray[j].m_data[n5]], (PdVector)pdVectorArray[piVectorArray[j].m_data[(n5 + 1) % 3]], (PdVector)pdVectorArray[piVectorArray[j].m_data[(n5 + 2) % 3]]) * Math.PI / 180.0;
            }
        }
        return Math.PI * 2 - d;
    }

    public static PdVector[] getMeanCurvature(PgElementSet pgElementSet, PdVector[] pdVectorArray) {
        int n;
        int n2;
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"elements must be triangular, no action");
            return pdVectorArray;
        }
        int n3 = pgElementSet.getDimOfVertices();
        int n4 = pgElementSet.getNumElements();
        int n5 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        pdVectorArray = PdVector.realloc((PdVector[])pdVectorArray, (int)n5, (int)n3);
        PdVector.setConstant((PdVector[])pdVectorArray, (double)0.0);
        double[] dArray = new double[3];
        PdVector[] pdVectorArray3 = new PdVector[3];
        PdVector[] pdVectorArray4 = new PdVector[3];
        PdVector pdVector = new PdVector(n3);
        double[] dArray2 = new double[n5];
        pgElementSet.makeNeighbour();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        for (n2 = 0; n2 < 3; ++n2) {
            pdVectorArray4[n2] = new PdVector(n3);
        }
        for (n = 0; n < n5; ++n) {
            pdVectorArray2[n].clearTag(0);
        }
        for (n = 0; n < n4; ++n) {
            pdVectorArray3 = pgElementSet.getElementVertices(n);
            double d = PdVector.area((PdVector[])pdVectorArray3);
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray3[0], (PdVector)pdVectorArray3[1], (PdVector)pdVectorArray3[2]);
            for (n2 = 0; n2 < 3; ++n2) {
                pdVectorArray4[n2].sub(pdVectorArray3[(n2 - 1 + 3) % 3], pdVectorArray3[(n2 + 1 + 3) % 3]);
            }
            for (n2 = 0; n2 < 3; ++n2) {
                int n6 = (n2 - 1 + 3) % 3;
                int n7 = (n2 + 1 + 3) % 3;
                PiVector piVector = piVectorArray2[n];
                if (piVector.m_data[n6] == -1) {
                    if (piVector.m_data[n7] == -1) {
                        pdVector.setConstant(0.0);
                    } else {
                        pdVector.blend(-dArray[n6], pdVectorArray4[n6], dArray[n2], pdVectorArray4[n2]);
                    }
                } else if (piVector.m_data[n7] == -1) {
                    pdVector.blend(-dArray[n2], pdVectorArray4[n2], dArray[n7], pdVectorArray4[n7]);
                } else {
                    pdVector.blend(-dArray[n6], pdVectorArray4[n6], dArray[n7], pdVectorArray4[n7]);
                }
                pdVectorArray[piVectorArray[n].m_data[n2]].add(pdVector);
                pdVectorArray2[piVectorArray[n].m_data[n2]].setTag(0);
                int n8 = piVectorArray[n].m_data[n2];
                dArray2[n8] = dArray2[n8] + d;
            }
        }
        for (n = 0; n < n5; ++n) {
            pdVectorArray[n].multScalar(0.5);
        }
        return pdVectorArray;
    }

    public static boolean getMeanCurvature(PgElementSet pgElementSet) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"elements must be triangular, no action");
            return false;
        }
        int n = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        pgElementSet.assureVertexNormals();
        PdVector[] pdVectorArray2 = null;
        pdVectorArray2 = PwCurvature.getMeanCurvature(pgElementSet, pdVectorArray2);
        PdVector[] pdVectorArray3 = pgElementSet.getVertexNormals();
        for (int i = 0; i < n; ++i) {
            if (pdVectorArray[i].hasTag(0)) {
                pdVectorArray3[i].copy(pdVectorArray2[i]);
                continue;
            }
            pdVectorArray3[i].setConstant(0.0);
        }
        return true;
    }

    public static PdVector getMeanCurvature(PgElementSet pgElementSet, PdVector pdVector) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"elements must be triangular, no action");
            return pdVector;
        }
        int n = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        if (!pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        PdVector[] pdVectorArray2 = pgElementSet.getVertexNormals();
        if (pdVector == null) {
            pdVector = new PdVector(n);
        } else if (pdVector.getSize() < n) {
            pdVector.setSize(n);
        }
        PdVector[] pdVectorArray3 = PwCurvature.getMeanCurvature(pgElementSet, (PdVector[])null);
        for (int i = 0; i < n; ++i) {
            pdVector.m_data[i] = 0.0;
            if (!pdVectorArray[i].hasTag(0)) continue;
            pdVector.m_data[i] = PdVector.dot((PdVector)pdVectorArray3[i], (PdVector)pdVectorArray2[i]) > 0.0 ? pdVectorArray3[i].length() : -pdVectorArray3[i].length();
            double[] dArray = pdVectorArray3[i].m_data;
        }
        return pdVector;
    }

    public static PdMatrix[] getShapeOperator(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray) {
        return PwCurvature.getShapeOperator(pgElementSet, pdMatrixArray, true);
    }

    public static PdMatrix[] getShapeOperator(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray, boolean bl) {
        int n;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Cannot compute shape operator. Given geometry is null.");
            return pdMatrixArray;
        }
        int n2 = pgElementSet.getNumVertices();
        int n3 = pgElementSet.getDimOfVertices();
        if (pdMatrixArray == null || pdMatrixArray.length < n2) {
            pdMatrixArray = PdMatrix.realloc(null, (int)n2, (int)n3, (int)n3);
        } else {
            for (n = 0; n < n2; ++n) {
                if (pdMatrixArray[n] == null || pdMatrixArray[n].getISize() != n3 || pdMatrixArray[n].getJSize() != n3) {
                    pdMatrixArray[n] = new PdMatrix(n3, n3);
                    continue;
                }
                pdMatrixArray[n].setConstant(0.0);
            }
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n4 = pgElementSet.getNumElements();
        double[] dArray = new double[3];
        PdVector pdVector = new PdVector(n3);
        PdVector pdVector2 = new PdVector(n3);
        PdVector pdVector3 = new PdVector(n3);
        PdVector pdVector4 = new PdVector(n3);
        PdMatrix pdMatrix = new PdMatrix(n3, n3);
        PdVector[] pdVectorArray2 = null;
        PdVector pdVector5 = new PdVector(3);
        pgElementSet.assureVertexNormals();
        pdVectorArray2 = pgElementSet.getVertexNormals();
        pgElementSet.assureElementNormals();
        for (n = 0; n < n4; ++n) {
            int n5 = piVectorArray[n].getSize();
            for (int i = 0; i < n5; ++i) {
                double d;
                int n6;
                if (piVectorArray2[n].m_data[i] < n) continue;
                PdVector pdVector6 = pdVectorArray[piVectorArray[n].m_data[i]];
                PdVector pdVector7 = pdVectorArray[piVectorArray[n].m_data[(i + 1) % n5]];
                PdVector pdVector8 = pdVectorArray[piVectorArray[n].m_data[(i + 2) % n5]];
                PuVectorGeom.ctg((double[])dArray, (PdVector)pdVector6, (PdVector)pdVector7, (PdVector)pdVector8);
                for (n6 = 0; n6 < n3; ++n6) {
                    pdVector3.m_data[n6] = dArray[1] * (pdVector8.m_data[n6] - pdVector6.m_data[n6]) + dArray[2] * (pdVector7.m_data[n6] - pdVector6.m_data[n6]);
                }
                pdVector6 = pdVectorArray[pgElementSet.getOppVertexInd(n, i)];
                PuVectorGeom.ctg((double[])dArray, (PdVector)pdVector6, (PdVector)pdVector7, (PdVector)pdVector8);
                for (n6 = 0; n6 < n3; ++n6) {
                    pdVector4.m_data[n6] = dArray[1] * (pdVector8.m_data[n6] - pdVector6.m_data[n6]) + dArray[2] * (pdVector7.m_data[n6] - pdVector6.m_data[n6]);
                }
                pdVector2.add(pdVector3, pdVector4);
                double d2 = pdVector2.length();
                if (d2 < 1.0E-10) continue;
                if (PdVector.dot((PdVector)pdVector2, (PdVector)pdVectorArray2[piVectorArray[n].m_data[(i + 1) % n5]]) < 0.0) {
                    d2 *= -1.0;
                }
                pdVector2.normalize();
                pdVector.sub(pdVector3, pdVector4);
                pdVector.normalize();
                if (bl) {
                    pdVector5.copyArray(pdVectorArray2[piVectorArray[n].m_data[(i + 1) % n5]]);
                    pdVector5.multScalar(-PdVector.dot((PdVector)pdVector, (PdVector)pdVector5));
                    pdVector5.add(pdVector);
                    pdVector5.normalize();
                    pdMatrix.adjoint(pdVector5);
                    d = d2 / 2.0 * Math.abs(PdVector.dot((PdVector)pdVector2, (PdVector)pdVectorArray2[piVectorArray[n].m_data[(i + 1) % n5]]));
                    pdMatrix.multScalar(d);
                    pdMatrixArray[piVectorArray[n].m_data[(i + 1) % n5]].add(pdMatrix);
                    pdVector5.copyArray(pdVectorArray2[piVectorArray[n].m_data[(i + 2) % n5]]);
                    pdVector5.multScalar(-PdVector.dot((PdVector)pdVector, (PdVector)pdVector5));
                    pdVector5.add(pdVector);
                    pdVector5.normalize();
                    pdMatrix.adjoint(pdVector5);
                    d = d2 / 2.0 * Math.abs(PdVector.dot((PdVector)pdVector2, (PdVector)pdVectorArray2[piVectorArray[n].m_data[(i + 2) % n5]]));
                    pdMatrix.multScalar(d);
                    pdMatrixArray[piVectorArray[n].m_data[(i + 2) % n5]].add(pdMatrix);
                    continue;
                }
                pdMatrix.adjoint(pdVector);
                d = d2 / 2.0;
                pdMatrix.multScalar(d);
                pdMatrixArray[piVectorArray[n].m_data[(i + 1) % n5]].add(pdMatrix);
                pdMatrix.adjoint(pdVector);
                d = d2 / 2.0;
                pdMatrix.multScalar(d);
                pdMatrixArray[piVectorArray[n].m_data[(i + 2) % n5]].add(pdMatrix);
            }
        }
        return pdMatrixArray;
    }

    public static PdMatrix[] getShapeOperator(PgElementSet pgElementSet, double d) {
        double d2;
        int n;
        int n2;
        int n3;
        PdMatrix[] pdMatrixArray = PwCurvature.getShapeOperator(pgElementSet, null, false);
        int n4 = pgElementSet.getNumVertices();
        int n5 = pgElementSet.getNumElements();
        int n6 = pgElementSet.getDimOfVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = piVectorArray[n3].m_data.length;
            for (n = 0; n < n2; ++n) {
                if (nArray[piVectorArray[n3].m_data[n]] != 0) continue;
                nArray[piVectorArray[n3].m_data[n]] = n3;
            }
        }
        double[] dArray = new double[n4];
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = piVectorArray[n3].m_data.length;
            d2 = pgElementSet.getAreaOfElement(n3);
            for (n = 0; n < n2; ++n) {
                int n7 = piVectorArray[n3].m_data[n];
                dArray[n7] = dArray[n7] + d2;
            }
        }
        PdMatrix[] pdMatrixArray2 = PdMatrix.realloc(null, (int)n4, (int)n6, (int)n6);
        PgVertexStar pgVertexStar = new PgVertexStar();
        boolean[] blArray = new boolean[n4];
        PiVector piVector = new PiVector(25);
        for (n3 = 0; n3 < n4; ++n3) {
            int n8 = 0;
            int n9 = 1;
            piVector.m_data[0] = n3;
            blArray[n3] = true;
            d2 = 0.0;
            while (n8 < n9) {
                int n10 = piVector.m_data[n8++];
                pdMatrixArray2[n3].add(pdMatrixArray[n10]);
                d2 += dArray[n10];
                pgVertexStar.makeVertexStar(pgElementSet, n10, nArray[n10]);
                int[] nArray2 = pgVertexStar.getLink().m_data;
                for (n = 0; n < nArray2.length; ++n) {
                    if (blArray[nArray2[n]] || PdVector.dist((PdVector)pdVectorArray[n3], (PdVector)pdVectorArray[nArray2[n]]) > d) continue;
                    blArray[nArray2[n]] = true;
                    if (piVector.m_data.length == n9) {
                        piVector.setSize(2 * n9);
                    }
                    piVector.m_data[n9++] = nArray2[n];
                }
            }
            pdMatrixArray2[n3].multScalar(1.0 / d2);
            for (n = 0; n < n9; ++n) {
                blArray[piVector.m_data[n]] = false;
            }
        }
        return pdMatrixArray2;
    }

    public static void getPrincipalCurvatures(PgElementSet pgElementSet, PdVector[] pdVectorArray, PdVector[][] pdVectorArray2) {
        PwCurvature.getPrincipalCurvatures(pgElementSet, null, pdVectorArray, pdVectorArray2);
    }

    public static void getPrincipalCurvatures(PgElementSet pgElementSet) {
        PwCurvature.getPrincipalCurvatures(pgElementSet, false);
    }

    public static void getPrincipalCurvatures(PgElementSet pgElementSet, boolean bl) {
        int n;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Cannot compute principal curvatures. Given geometry is null.");
            return;
        }
        int n2 = pgElementSet.getDimOfVertices();
        int n3 = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)2, (int)n3);
        PdVector[][] pdVectorArray2 = PdVector.alloc((int)2, (int)n3, (int)n2);
        PwCurvature.getPrincipalCurvatures(pgElementSet, null, pdVectorArray, pdVectorArray2);
        if (bl) {
            PnMassMatrix.multInvMassMatrix(pgElementSet, pdVectorArray[0], true);
            PnMassMatrix.multInvMassMatrix(pgElementSet, pdVectorArray[1], true);
        }
        for (int i = 0; i < 2; ++i) {
            for (n = 0; n < n3; ++n) {
                pdVectorArray2[i][n].setLength(Math.abs(pdVectorArray[i].m_data[n]));
            }
        }
        PgVectorField[] pgVectorFieldArray = new PgVectorField[2];
        for (n = 0; n < 2; ++n) {
            pgVectorFieldArray[n] = new PgVectorField(n2, 0);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
            pgVectorFieldArray[n].setVectors(pdVectorArray2[n]);
            pgElementSet.addVectorField(pgVectorFieldArray[n]);
        }
        pgVectorFieldArray[0].setName("Max Principal Curvature Direction");
        pgVectorFieldArray[1].setName("Min Principal Curvature Direction");
        pgVectorFieldArray = new PgVectorField[2];
        for (n = 0; n < 2; ++n) {
            pgVectorFieldArray[n] = new PgVectorField(n2, 0);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
            pgVectorFieldArray[n].setVectors(pdVectorArray2[n]);
            PdVector[] pdVectorArray3 = pgVectorFieldArray[n].getVectors();
            for (int i = 0; i < n3; ++i) {
                pdVectorArray3[i].multScalar(-1.0);
            }
            pgElementSet.addVectorField(pgVectorFieldArray[n]);
        }
        pgVectorFieldArray[0].setName("Max Principal Curvature Direction");
        pgVectorFieldArray[1].setName("Min Principal Curvature Direction");
    }

    public static void getPrincipalCurvatures(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray, PdVector[] pdVectorArray, PdVector[][] pdVectorArray2) {
        PwCurvature.getPrincipalCurvatures(pgElementSet, pdMatrixArray, pdVectorArray, pdVectorArray2, false);
    }

    public static void getPrincipalCurvatures(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray, PdVector[] pdVectorArray, PdVector[][] pdVectorArray2, boolean bl) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Cannot compute principal curvatures. Given geometry is null.");
            return;
        }
        int n = pgElementSet.getDimOfVertices();
        int n2 = pgElementSet.getNumVertices();
        pdMatrixArray = PwCurvature.getShapeOperator(pgElementSet, pdMatrixArray, true);
        PdVector pdVector = new PdVector(n);
        PdVector pdVector2 = new PdVector(n);
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)n, (int)n);
        int[] nArray = new int[n];
        for (int i = 0; i < n2; ++i) {
            int n3;
            PnJacobi.computeEigenvectors(pdMatrixArray[i], n, pdVector, pdVectorArray3);
            for (n3 = 0; n3 < n; ++n3) {
                pdVector2.m_data[n3] = Math.abs(pdVector.m_data[n3]);
            }
            PuMath.heapsort((int)n, (double[])pdVector2.m_data, (int[])nArray);
            if (!bl && pdVector.m_data[nArray[n - 1]] < pdVector.m_data[nArray[n - 2]]) {
                if (pdVectorArray2 != null) {
                    pdVectorArray2[0][i].copyArray(pdVectorArray3[nArray[n - 2]]);
                }
                if (pdVectorArray != null) {
                    pdVectorArray[0].m_data[i] = pdVector.m_data[nArray[n - 2]];
                }
                if (pdVectorArray2 != null) {
                    pdVectorArray2[1][i].copyArray(pdVectorArray3[nArray[n - 1]]);
                }
                if (pdVectorArray == null) continue;
                pdVectorArray[1].m_data[i] = pdVector.m_data[nArray[n - 1]];
                continue;
            }
            for (n3 = 0; n3 < 2; ++n3) {
                if (pdVectorArray2 != null) {
                    pdVectorArray2[n3][i].copyArray(pdVectorArray3[nArray[n - 1 - n3]]);
                }
                if (pdVectorArray == null) continue;
                pdVectorArray[n3].m_data[i] = pdVector.m_data[nArray[n - 1 - n3]];
            }
        }
    }

    protected static PdVector getEdgeCurv(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5, double[] dArray) {
        int n;
        if (pdVector5 == null || pdVector5.m_data.length < pdVector.m_data.length) {
            pdVector5 = new PdVector(pdVector.m_data.length);
        }
        if (dArray == null || dArray.length < 3) {
            dArray = new double[3];
        }
        PuVectorGeom.ctg((double[])dArray, (PdVector)pdVector, (PdVector)pdVector2, (PdVector)pdVector3);
        for (n = 0; n < pdVector.m_data.length; ++n) {
            pdVector5.m_data[n] = dArray[1] * (pdVector3.m_data[n] - pdVector.m_data[n]) + dArray[2] * (pdVector2.m_data[n] - pdVector.m_data[n]);
        }
        PuVectorGeom.ctg((double[])dArray, (PdVector)pdVector4, (PdVector)pdVector3, (PdVector)pdVector2);
        for (n = 0; n < pdVector.m_data.length; ++n) {
            int n2 = n;
            pdVector5.m_data[n2] = pdVector5.m_data[n2] + (dArray[2] * (pdVector3.m_data[n] - pdVector4.m_data[n]) + dArray[1] * (pdVector2.m_data[n] - pdVector4.m_data[n]));
        }
        return pdVector5;
    }
}

