/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuReflect;
import jvx.geom.PgFrame;

public class PnPolygon {
    public static PdVector computeCurvature(PgPolygon pgPolygon, PdVector pdVector, boolean bl) {
        return PnPolygon.computeCurvature(pgPolygon, null, pdVector, bl);
    }

    private static PdVector computeCurvature(PgPolygon pgPolygon, PdVector pdVector, PdVector pdVector2, boolean bl) {
        int n;
        int n2;
        if (pgPolygon == null) {
            PsDebug.warning((String)"missing polygon");
            return null;
        }
        int n3 = pgPolygon.getNumVertices();
        if (pdVector2 == null) {
            pdVector2 = new PdVector(n3);
        } else if (pdVector2.getSize() < n3) {
            pdVector2.setSize(n3);
        }
        if (n3 < 3) {
            pdVector2.setConstant(0.0);
            return pdVector2;
        }
        int n4 = pgPolygon.getDimOfVertices();
        if (n4 == 2 && !pgPolygon.hasVertexNormals()) {
            PsDebug.warning((String)"missing vertex normals");
            return null;
        }
        if (pdVector == null) {
            pdVector = new PdVector(n3);
            PnPolygon.computeEdgeLengths(pgPolygon, pdVector);
        }
        PdVector[] pdVectorArray = pgPolygon.getVertexNormals();
        PdVector[] pdVectorArray2 = pgPolygon.getVertices();
        PdVector pdVector3 = new PdVector(n4);
        PdVector pdVector4 = new PdVector(n4);
        PdVector pdVector5 = new PdVector(n4);
        if (!pgPolygon.isClosed()) {
            pdVector2.m_data[0] = 0.0;
            pdVector2.m_data[n3 - 1] = 0.0;
            n2 = 1;
            n = n3 - 1;
        } else {
            n2 = 0;
            n = n3;
        }
        int n5 = (n2 - 1 + n3) % n3;
        int n6 = (n2 + 1) % n3;
        int n7 = n2;
        while (n7 < n) {
            double d;
            if (pdVector.m_data[n7] < 1.0E-10) {
                PsDebug.warning((String)("degenerated edge after vertex " + n7 + ". stopping."));
                return pdVector2;
            }
            if (pdVector.m_data[n5] < 1.0E-10) {
                PsDebug.warning((String)("degenerated edge after vertex " + n5 + ". stopping."));
                return pdVector2;
            }
            pdVector3.sub(pdVectorArray2[n7], pdVectorArray2[n5]);
            pdVector4.sub(pdVectorArray2[n7], pdVectorArray2[n6]);
            pdVector3.multScalar(1.0 / pdVector.m_data[n5]);
            pdVector4.multScalar(1.0 / pdVector.m_data[n7]);
            pdVector5.add(pdVector3, pdVector4);
            double d2 = d = bl ? 1.0 : pdVector.m_data[(n7 + n3 - 1) % n3] + pdVector.m_data[n7];
            if (n4 == 2) {
                pdVector2.m_data[n7] = PdVector.dot((PdVector)pdVector5, (PdVector)pdVectorArray[n7]);
                pdVector2.m_data[n7] = pdVector2.m_data[n7] < 0.0 ? 1.0 : -1.0;
                int n8 = n7;
                pdVector2.m_data[n8] = pdVector2.m_data[n8] * (2.0 * pdVector5.length() / d);
            } else {
                pdVector2.m_data[n7] = 2.0 * pdVector5.length() / d;
            }
            if (++n6 >= n3) {
                n6 %= n3;
            }
            n5 = n7++;
        }
        return pdVector2;
    }

    public static PdVector computeCurvature(PgPolygon pgPolygon, PdVector pdVector, double d) {
        PdVector pdVector2 = PnPolygon.computeCurvature(pgPolygon, pdVector, true);
        int n = pgPolygon.getNumVertices();
        PdVector pdVector3 = new PdVector(n);
        block0: for (int i = 0; i < n; ++i) {
            double d2;
            int n2 = i;
            pdVector3.m_data[n2] = pdVector3.m_data[n2] + pdVector2.m_data[i];
            int n3 = i;
            for (d2 = 0.0; d2 < d && (n3 != n - 1 || pgPolygon.isClosed()); d2 += pgPolygon.getLengthOfEdge(n3)) {
                n3 = (n3 + 1) % n;
                if (!(d2 < d)) continue;
                int n4 = i;
                pdVector3.m_data[n4] = pdVector3.m_data[n4] + pdVector2.m_data[n3];
            }
            d2 = 0.0;
            n3 = i;
            while (d2 < d) {
                if (--n3 == -1) {
                    if (!pgPolygon.isClosed()) continue block0;
                    n3 = n - 1;
                }
                if (!((d2 += pgPolygon.getLengthOfEdge(n3)) < d)) continue;
                int n5 = i;
                pdVector3.m_data[n5] = pdVector3.m_data[n5] + pdVector2.m_data[n3];
            }
        }
        return pdVector3;
    }

    public static PdVector[] computeCurvatureVectors(PgPolygon pgPolygon, PdVector[] pdVectorArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (pgPolygon == null) {
            PsDebug.warning((String)"missing polygon");
            return null;
        }
        int n5 = pgPolygon.getDimOfVertices();
        int n6 = pgPolygon.getNumVertices();
        if (pdVectorArray == null || pdVectorArray.length < n6) {
            pdVectorArray = PdVector.realloc((PdVector[])pdVectorArray, (int)n6, (int)n5);
        }
        if (n6 < 3) {
            PdVector.setConstant((PdVector[])pdVectorArray, (double)0.0);
            return pdVectorArray;
        }
        PdVector[] pdVectorArray2 = pgPolygon.getVertices();
        PdVector pdVector = new PdVector(n5);
        PdVector pdVector2 = new PdVector(n5);
        if (pgPolygon.isClosed()) {
            n4 = 0;
            n3 = n6;
            n2 = n6 - 1;
            n = 1;
        } else {
            n4 = 1;
            n3 = n6 - 1;
            pdVectorArray[0].setConstant(0.0);
            pdVectorArray[n6 - 1].setConstant(0.0);
            n2 = 0;
            n = 2;
        }
        pdVector.sub(pdVectorArray2[n4], pdVectorArray2[n2]);
        double d = pgPolygon.getLengthOfEdge(n2);
        if (d < 1.0E-10) {
            PsDebug.warning((String)"degenerated edges");
            return pdVectorArray;
        }
        for (int i = n4; i < n3; ++i) {
            pdVector2.sub(pdVectorArray2[i], pdVectorArray2[n]);
            double d2 = pgPolygon.getLengthOfEdge(i);
            if (d2 < 1.0E-10) {
                PsDebug.warning((String)"degenerated edges");
                return pdVectorArray;
            }
            for (int j = 0; j < n5; ++j) {
                pdVectorArray[i].m_data[j] = -pdVector.m_data[j] / d - pdVector2.m_data[j] / d2;
                pdVector.m_data[j] = -pdVector2.m_data[j];
            }
            pdVectorArray[i].multScalar(2.0 / (d + d2));
            d = d2;
            if (++n < n6) continue;
            n %= n6;
        }
        return pdVectorArray;
    }

    public static void computeEdgeLengths(PgPolygon pgPolygon, PdVector pdVector) {
        if (pgPolygon == null) {
            PsDebug.warning((String)"missing polygon");
            return;
        }
        if (pdVector == null) {
            PsDebug.warning((String)"es must not be null");
            return;
        }
        int n = pgPolygon.getNumEdges();
        if (pdVector.getSize() < n) {
            pdVector.setSize(n);
        }
        for (int i = 0; i < n; ++i) {
            pdVector.m_data[i] = pgPolygon.getLengthOfEdge(i);
        }
    }

    public static PgFrame[] computeFrenetFrame(PgPolygon pgPolygon, PgFrame[] pgFrameArray) {
        int n = pgPolygon.getNumVertices();
        if (pgFrameArray == null || pgFrameArray.length < n) {
            pgFrameArray = PgFrame.realloc(pgFrameArray, n, 3);
        }
        pgPolygon.makeVertexNormals();
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        for (int i = 0; i < n; ++i) {
            pgFrameArray[i].getE2().copy(pgPolygon.getVertexNormal(i));
            if (i == n - 1) {
                pgFrameArray[i].getE1().sub(pdVectorArray[n - 1], pdVectorArray[n - 2]);
            } else {
                pgFrameArray[i].getE1().sub(pdVectorArray[i + 1], pdVectorArray[i]);
            }
            pgFrameArray[i].getE1().blendBase(pgFrameArray[i].getE1(), -PdVector.dot((PdVector)pgFrameArray[i].getE1(), (PdVector)pgFrameArray[i].getE2()), pgFrameArray[i].getE2());
            pgFrameArray[i].getE1().normalize();
            pgFrameArray[i].getE3().cross(pgFrameArray[i].getE1(), pgFrameArray[i].getE2());
        }
        return pgFrameArray;
    }

    public static PgFrame[] computeParallelFrame(PgPolygon pgPolygon, PgFrame[] pgFrameArray) {
        boolean bl = true;
        if (pgPolygon == null) {
            PsDebug.warning((String)"missing polygon");
            return null;
        }
        int n = pgPolygon.getNumVertices();
        boolean bl2 = pgPolygon.isClosed();
        if (pgFrameArray == null || pgFrameArray.length < n) {
            pgFrameArray = PgFrame.realloc(pgFrameArray, n, 3);
        }
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PgFrame pgFrame = new PgFrame(3);
        pgFrame.setBase(pdVectorArray[0]);
        pdVector.sub(pdVectorArray[1], pdVectorArray[0]);
        if (!pdVector.normalize()) {
            System.err.println("degenerate 1");
        }
        if (!bl || !bl2) {
            pgFrame.setE1(pdVector);
        } else {
            pdVector2.sub(pdVectorArray[0], pdVectorArray[n - 1]);
            pdVector2.normalize();
            pdVector2.add(pdVector);
            pdVector2.normalize();
            pgFrame.setE1(pdVector2);
        }
        pdVector2.normalToVector(pgFrame.getE1());
        pgFrame.setE2(pdVector2);
        pdVector2.cross(pgFrame.getE1(), pgFrame.getE2());
        pgFrame.setE3(pdVector2);
        pgFrameArray[0].copyVectors(pgFrame);
        for (int i = 1; i < n; ++i) {
            if (!bl) {
                if (bl2 || i < n - 1) {
                    pdVector.sub(pdVectorArray[(i + 1) % n], pdVectorArray[i]);
                    pgFrame.parallelTranslateConstantLength(pgFrame, pgFrameArray[i], pdVectorArray[i], pdVector);
                    continue;
                }
                pgFrameArray[i].copyVectors(pgFrame);
                continue;
            }
            if (!bl) continue;
            if (bl2 || i < n - 1) {
                pdVector2.copy(pdVector);
                pdVector.sub(pdVectorArray[(i + 1) % n], pdVectorArray[i]);
                pdVector.normalize();
                pdVector2.add(pdVector);
                pdVector2.normalize();
            } else {
                pdVector2.copy(pdVector);
            }
            PnPolygon.frameTranslate(pgFrame, pgFrameArray[i], pdVectorArray[i], pdVector2);
        }
        if (pgPolygon.isClosed()) {
            PgFrame pgFrame2 = new PgFrame(3);
            if (!bl) {
                pdVector.sub(pdVectorArray[1], pdVectorArray[0]);
                pgFrame.parallelTranslateConstantLength(pgFrame, pgFrameArray[0], pdVectorArray[0], pdVector);
                pdVector.sub(pdVectorArray[2], pdVectorArray[1]);
                pgFrame.parallelTranslateConstantLength(pgFrame, pgFrame2, pdVectorArray[1], pdVector);
            } else if (bl) {
                PnPolygon.frameTranslate(pgFrame, pgFrameArray[0], pdVectorArray[0], pgFrameArray[0].getE1());
                PnPolygon.frameTranslate(pgFrame, pgFrame2, pdVectorArray[1], pgFrameArray[1].getE1());
            }
            double d = PdVector.angle((PdVector)pgFrame2.getE2(), (PdVector)pgFrameArray[1].getE2());
            if (Math.abs(d) > 0.01) {
                d *= -Math.PI / 180;
                double d2 = d /= (double)n;
                PdMatrix pdMatrix = new PdMatrix(3);
                for (int i = 2; i < n + 1; ++i) {
                    PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pgFrameArray[i % n].getE1(), (double)d2);
                    pgFrameArray[i % n].leftMultMatrix(pdMatrix);
                    d2 += d;
                }
            }
        }
        return pgFrameArray;
    }

    private static void frameTranslate(PgFrame pgFrame, PgFrame pgFrame2, PdVector pdVector, PdVector pdVector2) {
        pgFrame2.setBase(pdVector);
        double d = PdVector.angle((PdVector)pgFrame.getE1(), (PdVector)pdVector2);
        if (Math.abs(d) < 179.999 && Math.abs(d) > 0.001) {
            d *= Math.PI / 180;
            PdVector pdVector3 = new PdVector(3);
            pdVector3.cross(pgFrame.getE1(), pdVector2);
            pdVector3.normalize();
            PdMatrix pdMatrix = new PdMatrix(3);
            boolean bl = PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector3, (double)d);
            if (!bl) {
                return;
            }
            pgFrame2.leftMultMatrix(pdMatrix, pgFrame);
        } else {
            pgFrame2.copyVectors(pgFrame);
        }
        pgFrame.copy(pgFrame2);
    }

    public static void computeParallelFrame(PgPolygon pgPolygon) {
        int n = pgPolygon.getDimOfVertices();
        if (n != 3) {
            PsDebug.warning((String)"wrong polygon dimension != 3");
            return;
        }
        int n2 = pgPolygon.getNumVertices();
        if (n2 < 3) {
            PsDebug.warning((String)"too few vertices < 3");
            return;
        }
        PgFrame[] pgFrameArray = PnPolygon.computeParallelFrame(pgPolygon, null);
        PgVectorField pgVectorField = new PgVectorField(n);
        PgVectorField pgVectorField2 = new PgVectorField(n);
        pgVectorField.setGeometry((PgPointSet)pgPolygon);
        pgVectorField2.setGeometry((PgPointSet)pgPolygon);
        pgVectorField.setName("parallel normal1");
        pgVectorField2.setName("parallel normal2");
        for (int i = 0; i < pgFrameArray.length; ++i) {
            pgVectorField.setVector(i, pgFrameArray[i].getE2());
            pgVectorField2.setVector(i, pgFrameArray[i].getE3());
        }
        pgPolygon.addVectorField(pgVectorField);
        pgPolygon.addVectorField(pgVectorField2);
    }

    public static void computeFrenetFrame(PgPolygon pgPolygon) {
        int n = pgPolygon.getDimOfVertices();
        if (n != 3) {
            PsDebug.warning((String)"wrong polygon dimension != 3");
            return;
        }
        int n2 = pgPolygon.getNumVertices();
        if (n2 < 3) {
            PsDebug.warning((String)"too few vertices < 3");
            return;
        }
        PgVectorField pgVectorField = new PgVectorField(n);
        PgVectorField pgVectorField2 = new PgVectorField(n);
        PgVectorField pgVectorField3 = new PgVectorField(n);
        pgVectorField.setGeometry((PgPointSet)pgPolygon);
        pgVectorField2.setGeometry((PgPointSet)pgPolygon);
        pgVectorField3.setGeometry((PgPointSet)pgPolygon);
        pgVectorField.setName("frenet tangent");
        pgVectorField2.setName("frenet normal1");
        pgVectorField3.setName("frenet normal2");
        PgFrame[] pgFrameArray = null;
        pgFrameArray = PnPolygon.computeFrenetFrame(pgPolygon, pgFrameArray);
        for (int i = 0; i < n2; ++i) {
            pgVectorField.setVector(i, pgFrameArray[i].getE1());
            pgVectorField2.setVector(i, pgFrameArray[i].getE2());
            pgVectorField3.setVector(i, pgFrameArray[i].getE3());
        }
        pgPolygon.addVectorField(pgVectorField);
        pgPolygon.addVectorField(pgVectorField2);
        pgPolygon.addVectorField(pgVectorField3);
    }

    public static void identifyVertices(PgPolygon pgPolygon) {
        PnPolygon.identifyVertices(pgPolygon, 1.0E-10);
    }

    public static void identifyVertices(PgPolygon pgPolygon, double d) {
        int n = pgPolygon.getNumVertices();
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        for (int i = 0; i < n; ++i) {
            double d2 = PdVector.dist((PdVector)pdVectorArray[(i + 1) % n], (PdVector)pdVectorArray[i]);
            if (!(d2 < d)) continue;
            pdVectorArray[i].setTag(2);
        }
        if (pdVectorArray[n - 1].hasTag(2)) {
            pgPolygon.setClosed(true);
        }
        pgPolygon.removeMarkedVertices();
    }

    public static void reverse(PgPolygon pgPolygon) {
        int n = pgPolygon.getNumVertices();
        int n2 = n / 2;
        int n3 = pgPolygon.getDimOfVertices();
        PdVector pdVector = new PdVector(n3);
        for (int i = 0; i < n2; ++i) {
            pdVector.copy(pgPolygon.getVertex(i));
            pgPolygon.setVertex(i, pgPolygon.getVertex(n - i - 1));
            pgPolygon.setVertex(n - i - 1, pdVector);
        }
    }
}

