/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class PnEvolve {
    public static final int OFFSET_VERTEX_NORMAL = 2;
    public static final int OFFSET_VERTEX_VECTOR = 4;
    public static final int OFFSET_MEAN_CURVATURE = 8;
    public static final int OFFSET_GAUSS_CURVATURE = 16;

    public static boolean evolveParallel(PgPointSet pgPointSet, double d) {
        PdVector[] pdVectorArray;
        if (!pgPointSet.hasVertexNormals()) {
            pgPointSet.makeVertexNormals();
        }
        if ((pdVectorArray = pgPointSet.getVertexNormals()) == null) {
            PsDebug.warning((String)"missing vertex normals");
            return false;
        }
        PnEvolve.evolve(pgPointSet.getNumVertices(), pgPointSet.getVertices(), pdVectorArray, d);
        return true;
    }

    public static boolean evolveVectorField(PgPointSet pgPointSet, double d) {
        if (pgPointSet.getNumVectorFields() < 1) {
            PsDebug.warning((String)"missing vector field.");
            return false;
        }
        PgVectorField pgVectorField = pgPointSet.getSelectedVectorField();
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing selected vector field, taking first vf.");
            pgVectorField = pgPointSet.getVectorField(0);
        }
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing vector field");
            return false;
        }
        if (pgVectorField.getBasedOn() != 0) {
            PsDebug.warning((String)"vector field is not vertex based.");
            return false;
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        PnEvolve.evolve(pgPointSet.getNumVertices(), pgPointSet.getVertices(), pdVectorArray, d);
        return true;
    }

    private static void evolve(int n, PdVector[] pdVectorArray, PdVector[] pdVectorArray2, double d) {
        for (int i = 0; i < n; ++i) {
            pdVectorArray[i].blendBase(pdVectorArray[i], d, pdVectorArray2[i]);
        }
    }
}

