/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PnConjugate {
    public static PgElementSet conjugate(PgElementSet pgElementSet, PgElementSet pgElementSet2, PgElementSet pgElementSet3) {
        int n;
        int n2;
        int[] nArray;
        int n3;
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface");
            return null;
        }
        if (pgElementSet2.getDimOfElements() != 3) {
            PsDebug.warning((String)"dim of elements must be 3", (Object)pgElementSet2);
            return null;
        }
        int n4 = pgElementSet2.getDimOfVertices();
        int n5 = pgElementSet2.getDimOfElements();
        int n6 = pgElementSet2.getNumElements();
        PdVector[] pdVectorArray = pgElementSet2.getVertices();
        PiVector[] piVectorArray = pgElementSet2.getElements();
        PiVector[] piVectorArray2 = pgElementSet2.getNeighbours();
        if (pgElementSet == null) {
            pgElementSet = new PgElementSet(n4);
            pgElementSet.setName(PsConfig.getMessage((int)45002) + " " + pgElementSet2.getName());
        }
        double d = pgElementSet3 != null && pgElementSet3.isConforming() ? -1.0 : 2.0;
        pgElementSet.copy((PsObject)pgElementSet2);
        if (pgElementSet2.isConforming()) {
            PnConjugate.makeNonConforming(pgElementSet);
        }
        PdVector[] pdVectorArray2 = pgElementSet3 != null ? pgElementSet3.getVertices() : pgElementSet2.getVertices();
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)n5, (int)n4);
        PdVector pdVector = new PdVector(n4);
        PdVector[] pdVectorArray4 = PdVector.realloc(null, (int)(n5 * n6), (int)n4);
        double[] dArray = new double[n5];
        for (n3 = 0; n3 < n6; ++n3) {
            nArray = piVectorArray[n3].m_data;
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray2[nArray[0]], (PdVector)pdVectorArray2[nArray[1]], (PdVector)pdVectorArray2[nArray[2]]);
            pdVectorArray4[n5 * n3].setConstant(0.0);
            for (n2 = 0; n2 < n5; ++n2) {
                pdVectorArray3[n2].sub(pdVectorArray[nArray[(n2 + 2) % n5]], pdVectorArray[nArray[(n2 + 1) % n5]]);
                pdVectorArray3[n2].multScalar(d * dArray[n2]);
            }
            for (n2 = 1; n2 < n5; ++n2) {
                pdVector.sub(pdVectorArray3[(n2 + 2) % n5], pdVectorArray3[n2]);
                pdVectorArray4[n5 * n3 + n2].add(pdVectorArray4[n5 * n3 + n2 - 1], pdVector);
            }
        }
        PdVector[][] pdVectorArray5 = PdVector.alloc((int)n6, (int)n5, (int)n4);
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                pdVectorArray5[n3][n2].blend(0.5, pdVectorArray4[n5 * n3 + (n2 + 1) % n5], 0.5, pdVectorArray4[n5 * n3 + (n2 + 2) % n5]);
            }
        }
        int n7 = 0;
        int n8 = 1;
        int n9 = 2;
        PiVector piVector = new PiVector(n6);
        PdVector[] pdVectorArray6 = PdVector.realloc(null, (int)n6, (int)n4);
        PdVector[] pdVectorArray7 = pgElementSet.getVertices();
        piVector.setConstant(n7);
        piVector.m_data[0] = n8;
        pdVectorArray6[0].setConstant(0.0);
        int n10 = 0;
        while ((n = piVector.getIndexOf(n8)) != -1) {
            piVector.m_data[n] = n9;
            nArray = piVectorArray[n].m_data;
            for (n2 = 0; n2 < n5; ++n2) {
                int n11 = piVectorArray2[n].m_data[n2];
                if (n11 != -1 && piVector.m_data[n11] == n9) continue;
                pdVectorArray7[n10].add(pdVectorArray5[n][n2], pdVectorArray6[n]);
                ++n10;
                if (n11 == -1 || piVector.m_data[n11] == n8) continue;
                int n12 = pgElementSet2.getOppVertexLocInd(n, n2);
                pdVectorArray6[n11].sub(pdVectorArray7[n10 - 1], pdVectorArray5[n11][n12]);
                piVector.m_data[n11] = n8;
            }
        }
        return pgElementSet;
    }

    public static PgElementSet conjugateToFull(PgElementSet pgElementSet, PgElementSet pgElementSet2, PgElementSet pgElementSet3) {
        int n;
        int n2;
        int n3;
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface");
            return null;
        }
        int n4 = pgElementSet2.getDimOfElements();
        if (n4 != 3) {
            PsDebug.warning((String)"dim of elements must be 3", (Object)pgElementSet2);
            return null;
        }
        int n5 = pgElementSet2.getDimOfVertices();
        int n6 = pgElementSet2.getNumElements();
        PdVector[] pdVectorArray = pgElementSet2.getVertices();
        PiVector[] piVectorArray = pgElementSet2.getElements();
        PiVector[] piVectorArray2 = pgElementSet2.getNeighbours();
        if (pgElementSet == null) {
            pgElementSet = new PgElementSet(n5);
        }
        double d = pgElementSet3 != null && pgElementSet3.isConforming() ? -1.0 : 2.0;
        pgElementSet.copy((PsObject)pgElementSet2);
        pgElementSet.setName(PsConfig.getMessage((int)45002) + " " + pgElementSet2.getName());
        pgElementSet.setNumElements(n6);
        pgElementSet.setNumVertices(3 * n6);
        PiVector[] piVectorArray3 = pgElementSet.getElements();
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                piVectorArray3[n3].m_data[n2] = n4 * n3 + n2;
            }
        }
        PdVector[] pdVectorArray2 = pgElementSet3 != null ? pgElementSet3.getVertices() : pgElementSet2.getVertices();
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)n4, (int)n5);
        PdVector pdVector = new PdVector(n5);
        PdVector[] pdVectorArray4 = PdVector.realloc(null, (int)(n4 * n6), (int)n5);
        double[] dArray = new double[n4];
        for (n3 = 0; n3 < n6; ++n3) {
            int[] nArray = piVectorArray[n3].m_data;
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray2[nArray[0]], (PdVector)pdVectorArray2[nArray[1]], (PdVector)pdVectorArray2[nArray[2]]);
            pdVectorArray4[n4 * n3].setConstant(0.0);
            for (n2 = 0; n2 < n4; ++n2) {
                pdVectorArray3[n2].sub(pdVectorArray[nArray[(n2 + 2) % n4]], pdVectorArray[nArray[(n2 + 1) % n4]]);
                pdVectorArray3[n2].multScalar(d * dArray[n2]);
            }
            for (n2 = 1; n2 < n4; ++n2) {
                pdVector.sub(pdVectorArray3[(n2 + 2) % n4], pdVectorArray3[n2]);
                pdVectorArray4[n4 * n3 + n2].add(pdVectorArray4[n4 * n3 + n2 - 1], pdVector);
            }
        }
        PdVector[][] pdVectorArray5 = PdVector.alloc((int)n6, (int)n4, (int)n5);
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                pdVectorArray5[n3][n2].blend(0.5, pdVectorArray4[n4 * n3 + (n2 + 1) % n4], 0.5, pdVectorArray4[n4 * n3 + (n2 + 2) % n4]);
            }
        }
        int n7 = 0;
        int n8 = 1;
        int n9 = 2;
        PiVector piVector = new PiVector(n6);
        PdVector[] pdVectorArray6 = PdVector.realloc(null, (int)n6, (int)n5);
        piVector.setConstant(n7);
        piVector.m_data[0] = n8;
        pdVectorArray6[0].setConstant(0.0);
        while ((n = piVector.getIndexOf(n8)) != -1) {
            piVector.m_data[n] = n9;
            for (n2 = 0; n2 < piVectorArray3[n].m_data.length; ++n2) {
                int n10 = piVectorArray2[n].m_data[n2];
                if (n10 == -1 || piVector.m_data[n10] != n7) continue;
                int n11 = piVectorArray2[n10].getIndexOf(n);
                pdVectorArray6[n10].sub(pdVectorArray5[n][n2], pdVectorArray5[n10][n11]);
                pdVectorArray6[n10].add(pdVectorArray6[n]);
                piVector.m_data[n10] = n8;
            }
        }
        PdVector[] pdVectorArray7 = pgElementSet.getVertices();
        n = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                pdVectorArray7[n].add(pdVectorArray4[n], pdVectorArray6[n3]);
                ++n;
            }
        }
        pgElementSet.setConforming(true);
        return pgElementSet;
    }

    public static boolean makeNonConforming(PgElementSet pgElementSet) {
        if (!pgElementSet.isConforming()) {
            return true;
        }
        int n = pgElementSet.getNumElements();
        if (n == 0) {
            pgElementSet.setConforming(false);
            return true;
        }
        int n2 = pgElementSet.getNumEdges();
        pgElementSet.setSavedNumVertices(pgElementSet.getNumVertices());
        pgElementSet.setNumVertices(n2);
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        PiVector[] piVectorArray3 = PiVector.copyNew((PiVector[])piVectorArray2, (int)pgElementSet.getMaxNumElements());
        PdVector[] pdVectorArray2 = PdVector.realloc(null, (int)n2, (int)pgElementSet.getDimOfVertices());
        int n3 = 0;
        int n4 = 1;
        int n5 = 2;
        PiVector piVector = new PiVector(n);
        piVector.setConstant(n3);
        int n6 = 0;
        piVector.m_data[n6] = n4;
        int n7 = 0;
        while ((n6 = piVector.getIndexOf(n4)) != -1) {
            piVector.m_data[n6] = n5;
            int n8 = piVectorArray2[n6].getSize();
            for (int i = 0; i < n8; ++i) {
                int n9 = piVectorArray[n6].m_data[i];
                if (n9 != -1 && piVector.m_data[n9] == n5) continue;
                PdVector pdVector = pdVectorArray[piVectorArray2[n6].m_data[(i + 1) % n8]];
                PdVector pdVector2 = pdVectorArray[piVectorArray2[n6].m_data[(i + 2) % n8]];
                pdVectorArray2[n7].blend(0.5, pdVector, 0.5, pdVector2);
                piVectorArray3[n6].m_data[i] = n7;
                if (n9 != -1) {
                    piVectorArray3[n9].m_data[pgElementSet.getOppVertexLocInd((int)n6, (int)i)] = n7;
                    piVector.m_data[n9] = n4;
                }
                ++n7;
            }
        }
        for (n7 = 0; n7 < n2; ++n7) {
            pdVectorArray[n7].copy(pdVectorArray2[n7]);
        }
        pgElementSet.setSavedElements(piVectorArray2);
        pgElementSet.setElements(piVectorArray3);
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                pgBndPolygonArray[i].makeNonConforming();
            }
        }
        pgElementSet.setConforming(false);
        return true;
    }

    public static boolean makeConforming(PgElementSet pgElementSet) {
        int n;
        int n2;
        if (pgElementSet.isConforming()) {
            return true;
        }
        int n3 = pgElementSet.getNumElements();
        if (n3 == 0) {
            pgElementSet.setConforming(true);
            return true;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"dimOfElements!=3, for a reconstruction at most 3 vertices per element");
            return false;
        }
        PdVector[] pdVectorArray = new PdVector[3];
        int n4 = pgElementSet.getNumEdges();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)n4, (int)pgElementSet.getDimOfVertices());
        for (n2 = 0; n2 < n4; ++n2) {
            pdVectorArray3[n2].copy(pdVectorArray2[n2]);
        }
        pgElementSet.setNumVertices(pgElementSet.getSavedNumVertices());
        pdVectorArray2 = pgElementSet.getVertices();
        PiVector[] piVectorArray2 = pgElementSet.getSavedElements();
        if (piVectorArray2 == null) {
            PsDebug.warning((String)"missing saved elements.");
            return false;
        }
        int n5 = 3;
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            int n6;
            for (n6 = 0; n6 < n5; ++n6) {
                pdVectorArray[n6] = pdVectorArray3[piVectorArray[n].m_data[n6]];
            }
            for (n6 = 0; n6 < n5; ++n6) {
                pdVectorArray2[piVectorArray2[n].m_data[n6]].add(pdVectorArray[(n6 + 1) % n5], pdVectorArray[(n6 + 2) % n5]);
                pdVectorArray2[piVectorArray2[n].m_data[n6]].sub(pdVectorArray[n6]);
            }
        }
        pgElementSet.setElements(piVectorArray2);
        pgElementSet.setSavedElements(null);
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            for (n = 0; n < pgBndPolygonArray.length; ++n) {
                pgBndPolygonArray[n].makeConforming();
            }
        }
        pgElementSet.setConforming(true);
        return true;
    }

    public static boolean makeConformingToFull(PgElementSet pgElementSet) {
        int n;
        int n2;
        int n3;
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing surface");
            return false;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"dim of elements must be 3", (Object)pgElementSet);
            return false;
        }
        int n4 = pgElementSet.getDimOfVertices();
        int n5 = pgElementSet.getDimOfElements();
        int n6 = pgElementSet.getNumElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PdVector[] pdVectorArray2 = PdVector.realloc(null, (int)(n5 * n6), (int)n4);
        for (n3 = 0; n3 < n6; ++n3) {
            int[] nArray = piVectorArray[n3].m_data;
            if (pgElementSet.isConforming()) {
                pdVectorArray2[n5 * n3].setConstant(0.0);
                for (n2 = 1; n2 < n5; ++n2) {
                    pdVectorArray2[n5 * n3 + n2].sub(pdVectorArray[nArray[n2]], pdVectorArray[nArray[0]]);
                }
                continue;
            }
            for (n2 = 0; n2 < n5; ++n2) {
                pdVectorArray2[n5 * n3 + n2].add(pdVectorArray[nArray[(n2 - 1 + n5) % n5]], pdVectorArray[nArray[(n2 + 1) % n5]]);
                pdVectorArray2[n5 * n3 + n2].sub(pdVectorArray[nArray[n2]]);
            }
            for (n2 = 1; n2 < n5; ++n2) {
                pdVectorArray2[n5 * n3 + n2].sub(pdVectorArray2[n5 * n3]);
            }
            pdVectorArray2[n5 * n3].sub(pdVectorArray2[n5 * n3]);
        }
        PdVector[][] pdVectorArray3 = PdVector.alloc((int)n6, (int)n5, (int)n4);
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                pdVectorArray3[n3][n2].blend(0.5, pdVectorArray2[n5 * n3 + (n2 + 1) % n5], 0.5, pdVectorArray2[n5 * n3 + (n2 + 2) % n5]);
            }
        }
        pgElementSet.setSavedNumVertices(pgElementSet.getNumVertices());
        pgElementSet.setNumVertices(3 * n6);
        PiVector[] piVectorArray3 = pgElementSet.getElements();
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                piVectorArray3[n3].m_data[n2] = n5 * n3 + n2;
            }
        }
        int n7 = 0;
        int n8 = 1;
        int n9 = 2;
        PiVector piVector = new PiVector(n6);
        PdVector[] pdVectorArray4 = PdVector.realloc(null, (int)n6, (int)n4);
        piVector.setConstant(n7);
        piVector.m_data[0] = n8;
        pdVectorArray4[0].setConstant(0.0);
        while ((n = piVector.getIndexOf(n8)) != -1) {
            piVector.m_data[n] = n9;
            for (n2 = 0; n2 < piVectorArray3[n].m_data.length; ++n2) {
                int n10 = piVectorArray2[n].m_data[n2];
                if (n10 == -1 || piVector.m_data[n10] != n7) continue;
                int n11 = piVectorArray2[n10].getIndexOf(n);
                pdVectorArray4[n10].sub(pdVectorArray3[n][n2], pdVectorArray3[n10][n11]);
                pdVectorArray4[n10].add(pdVectorArray4[n]);
                piVector.m_data[n10] = n8;
            }
        }
        n = 0;
        PdVector[] pdVectorArray5 = pgElementSet.getVertices();
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                pdVectorArray5[n].add(pdVectorArray2[n], pdVectorArray4[n3]);
                ++n;
            }
        }
        pgElementSet.setConforming(true);
        return true;
    }
}

