/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.geom.PwCurvature;
import jvx.numeric.PnMassMatrix;
import jvx.numeric.PnStraightestGeodesic;

public class PgPolygonOnElementSet
extends PgPolygon {
    public static double BARYEPS = 0.005;
    public double m_eps = BARYEPS;
    protected PgElementSet m_geom;
    protected static final int m_dimOfElements = 3;
    protected PdBary[] m_vertexBary = new PdBary[0];
    protected transient PnStraightestGeodesic m_exp;
    private transient PdVector[] m_bary = new PdVector[3];
    private transient PdBaryDir m_diff = new PdBaryDir(3);
    private transient int[] m_notzero = new int[2];
    private transient int[] m_zero = new int[2];
    private transient int[] m_numzero = new int[2];
    private transient PdBary[] m_v = null;
    private transient int[] m_n = new int[2];
    private transient PiVector[] m_altElem = null;
    private transient PgVertexStar[] m_star = null;
    private transient boolean[] m_bStarUsed = new boolean[2];
    static /* synthetic */ Class class$jvx$geom$PgPolygonOnElementSet;

    public PgPolygonOnElementSet(PgElementSet pgElementSet) {
        this(pgElementSet.getDimOfVertices());
        this.setGeometry(pgElementSet);
    }

    public PgPolygonOnElementSet(int n) {
        super(n);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PgPolygonOnElementSet == null ? (class$jvx$geom$PgPolygonOnElementSet = PgPolygonOnElementSet.class$("jvx.geom.PgPolygonOnElementSet")) : class$jvx$geom$PgPolygonOnElementSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\t ******* PgPolygonOnElementSet ******\n");
        stringBuffer.append("\t ******* m_vertexBary *******\n");
        if (this.m_vertexBary != null && ((PgPointSet)this).m_numVertices > 0) {
            for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
                stringBuffer.append("\t [" + i + "] = " + this.m_vertexBary[i].toShortString());
            }
        } else {
            stringBuffer.append("\t m_vertexBary = null\n");
        }
        return stringBuffer.toString();
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry is not triangulated.");
            return;
        }
        this.m_geom = pgElementSet;
        if (pgElementSet.getDimOfVertices() != ((PgGeometry)this).m_dim) {
            this.setDimOfVertices(pgElementSet.getDimOfVertices());
        }
        if (this.m_exp != null) {
            this.m_exp.setGeometry(pgElementSet);
        }
    }

    public Object clone() {
        PgPolygonOnElementSet pgPolygonOnElementSet = (PgPolygonOnElementSet)((Object)super.clone());
        if (pgPolygonOnElementSet == null) {
            return null;
        }
        if (this.m_geom != null) {
            pgPolygonOnElementSet.setGeometry(this.m_geom);
        }
        pgPolygonOnElementSet.m_exp = null;
        if (this.m_vertexBary != null) {
            pgPolygonOnElementSet.m_vertexBary = (PdBary[])P_Vector.clone((P_Vector[])this.m_vertexBary);
        }
        return pgPolygonOnElementSet;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgPolygonOnElementSet)) {
            return;
        }
        PgPolygonOnElementSet pgPolygonOnElementSet = (PgPolygonOnElementSet)psObject;
        this.m_eps = pgPolygonOnElementSet.m_eps;
        this.m_exp = null;
        PdBary.copy((PdBary[])this.m_vertexBary, (int)0, (PdBary[])pgPolygonOnElementSet.getVertexBary(), (int)0, (int)((PgPointSet)this).m_numVertices);
    }

    public void copyIntrinsicData(PgPolygonOnElementSet pgPolygonOnElementSet) {
        this.copy((PsObject)pgPolygonOnElementSet);
    }

    public void setMaxNumVertices(int n) {
        if (((PgPointSet)this).m_maxNumVertices == n) {
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            ((PgPointSet)this).m_maxNumVertices = n;
            return;
        }
        super.setMaxNumVertices(n);
        this.m_vertexBary = PdBary.realloc((PdBary[])this.m_vertexBary, (int)n, (int)3);
    }

    public PdBary[] getVertexBary() {
        return this.m_vertexBary;
    }

    public PdBary getVertexBary(int n) {
        if (n < 0 || n >= ((PgPointSet)this).m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return null;
        }
        return this.m_vertexBary[n];
    }

    public int getVertexElemInd(int n) {
        if (n < 0 || n >= ((PgPointSet)this).m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return -1;
        }
        return this.m_vertexBary[n].getElementInd();
    }

    public PiVector getVertexElemInd() {
        PiVector piVector = new PiVector(((PgPointSet)this).m_numVertices);
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            piVector.m_data[i] = this.m_vertexBary[i].getElementInd();
        }
        return piVector;
    }

    public void setVertexBary(int n, int n2, PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"Missing bary vector.");
            return;
        }
        if (n < 0 || n >= ((PgPointSet)this).m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return;
        }
        if (n2 < 0 || this.m_geom != null && n2 >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)("Element index out of bounds: " + n2 + "."));
            return;
        }
        if (this.m_geom != null) {
            PiVector piVector = this.m_geom.getElement(n2);
            pdBary.getVertex(((PgPointSet)this).m_vertex[n], this.m_geom.getVertex(piVector.m_data[0]), this.m_geom.getVertex(piVector.m_data[1]), this.m_geom.getVertex(piVector.m_data[2]));
        }
        this.m_vertexBary[n].copy(pdBary);
        this.m_vertexBary[n].setElementInd(n2);
    }

    public void setVertexBary(int n, PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"Missing bary vector.");
            return;
        }
        this.setVertexBary(n, pdBary.getElementInd(), pdBary);
    }

    public void computeVertices() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing surface.");
            return;
        }
        if (((PgPointSet)this).m_numVertices == 0) {
            return;
        }
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            int n = this.m_vertexBary[i].getElementInd();
            if (n == -1) {
                PsDebug.warning((String)("Missing element index in vertexBary[" + i + "]"));
                return;
            }
            PiVector piVector = this.m_geom.getElement(n);
            this.m_vertexBary[i].getVertex(((PgPointSet)this).m_vertex[i], this.m_geom.getVertex(piVector.m_data[0]), this.m_geom.getVertex(piVector.m_data[1]), this.m_geom.getVertex(piVector.m_data[2]));
        }
    }

    public double eval(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PiVector piVector, double d) {
        int n;
        int n2;
        int n3;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing geometry (forgot to call of 'setGeometry(..)'?).");
            return 0.0;
        }
        if (((PgPointSet)this).m_numVertices < 1) {
            pdVector.setSize(0);
            pdVector2.setSize(0);
            pdVector3.setSize(0);
            piVector.setSize(0);
            return 0.0;
        }
        int n4 = pdVector.getSize();
        int n5 = 100;
        this.m_bary[0] = pdVector;
        this.m_bary[1] = pdVector2;
        this.m_bary[2] = pdVector3;
        for (n3 = 0; n3 < 3; ++n3) {
            this.m_bary[n3].setSize(n4);
        }
        piVector.setSize(n4);
        n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n6 = 0;
        if (this.m_v == null) {
            this.m_v = PdBary.realloc(null, (int)2, (int)3);
        }
        if (this.m_star == null) {
            this.m_star = new PgVertexStar[2];
            this.m_star[0] = new PgVertexStar();
            this.m_star[1] = new PgVertexStar();
        }
        if (this.m_altElem == null) {
            this.m_altElem = PiVector.realloc(null, (int)2);
        }
        boolean bl = false;
        for (n2 = 0; n2 < 3; ++n2) {
            this.m_bary[n2].m_data[0] = this.m_vertexBary[0].m_data[n2];
        }
        piVector.m_data[0] = this.m_vertexBary[0].m_elementInd;
        n2 = 1;
        while (!bl) {
            int n7;
            d5 = d4;
            d4 += d;
            while (d2 + d3 <= d4 && n3 + 1 < ((PgPointSet)this).m_numVertices) {
                d2 += d3;
                if (this.m_vertexBary[n3].m_elementInd != this.m_vertexBary[n3 + 1].m_elementInd) {
                    int n8;
                    for (int i = 0; i < 2; ++i) {
                        this.m_notzero[i] = -1;
                        this.m_zero[i] = -1;
                        this.m_numzero[i] = 0;
                        for (n7 = 0; n7 < 3; ++n7) {
                            if (Math.abs(this.m_vertexBary[n3 + i].m_data[n7]) > 1.0E-10) {
                                this.m_notzero[i] = n7;
                                continue;
                            }
                            int n9 = i;
                            this.m_numzero[n9] = this.m_numzero[n9] + 1;
                            this.m_zero[i] = n7;
                        }
                    }
                    if (this.m_numzero[0] < 1 && this.m_numzero[1] < 1) {
                        PsDebug.warning((String)"Cannot do it in barycoords.");
                        return 0.0;
                    }
                    this.m_bStarUsed[0] = false;
                    this.m_bStarUsed[1] = false;
                    for (n7 = 0; n7 < 2; ++n7) {
                        n8 = this.m_vertexBary[n3 + n7].m_elementInd;
                        if (n8 == -1) {
                            PsDebug.message((String)"hmm");
                        }
                        if (this.m_numzero[n7] == 2) {
                            this.m_bStarUsed[n7] = true;
                            this.m_star[n7].makeVertexStar(this.m_geom, this.m_geom.getElement((int)n8).m_data[this.m_notzero[n7]], n8);
                            this.m_altElem[n7] = this.m_star[n7].getElement();
                            continue;
                        }
                        if (this.m_numzero[n7] == 1) {
                            this.m_altElem[n7].setSize(2);
                            this.m_altElem[n7].m_data[0] = n8;
                            this.m_altElem[n7].m_data[1] = this.m_geom.getNeighbour((int)n8).m_data[this.m_zero[n7]];
                            continue;
                        }
                        this.m_altElem[n7].setSize(1);
                        this.m_altElem[n7].m_data[0] = n8;
                    }
                    int n10 = -1;
                    int n11 = this.m_altElem[0].getSize();
                    int n12 = this.m_altElem[1].getSize();
                    this.m_n[0] = 0;
                    while (this.m_n[0] < n11) {
                        this.m_n[1] = 0;
                        while (this.m_n[1] < n12) {
                            if (this.m_altElem[0].m_data[this.m_n[0]] == this.m_altElem[1].m_data[this.m_n[1]]) {
                                n10 = this.m_altElem[0].m_data[this.m_n[0]];
                                break;
                            }
                            this.m_n[1] = this.m_n[1] + 1;
                        }
                        if (n10 != -1) break;
                        this.m_n[0] = this.m_n[0] + 1;
                    }
                    if (n10 == -1) {
                        PsDebug.warning((String)"Cannot do it in barycoords.");
                        return 0.0;
                    }
                    for (n7 = 0; n7 < 2; ++n7) {
                        int n13;
                        n8 = this.m_vertexBary[n3 + n7].m_elementInd;
                        if (this.m_bStarUsed[n7]) {
                            n13 = this.m_star[n7].getVertexLocInd().m_data[this.m_n[n7]];
                            this.m_v[n7].m_data[n13] = 1.0;
                            this.m_v[n7].m_data[(n13 + 1) % 3] = 0.0;
                            this.m_v[n7].m_data[(n13 + 2) % 3] = 0.0;
                            continue;
                        }
                        if (this.m_numzero[n7] == 1 && n8 != n10) {
                            double d6;
                            n13 = this.m_geom.getOppVertexLocInd(n8, this.m_zero[n7]);
                            this.m_v[n7].m_data[n13] = 0.0;
                            int n14 = (n13 + 1) % 3;
                            int n15 = (n13 + 2) % 3;
                            n11 = (this.m_zero[n7] + 1) % 3;
                            n12 = (this.m_zero[n7] + 2) % 3;
                            this.m_v[n7].m_data[n14] = d6 = this.m_vertexBary[n3 + n7].m_data[n12];
                            this.m_v[n7].m_data[n15] = d6 = this.m_vertexBary[n3 + n7].m_data[n11];
                            continue;
                        }
                        this.m_v[n7].copy(this.m_vertexBary[n3 + n7]);
                    }
                    n6 = n10;
                } else {
                    this.m_v[0].copy(this.m_vertexBary[n3]);
                    this.m_v[1].copy(this.m_vertexBary[n3 + 1]);
                    n6 = this.m_vertexBary[n3].m_elementInd;
                }
                for (n7 = 0; n7 < 3; ++n7) {
                    this.m_diff.m_data[n7] = this.m_v[1].m_data[n7] - this.m_v[0].m_data[n7];
                }
                d3 = PwBary.norm(this.m_geom, n6, this.m_diff, n2 == 0);
                ++n3;
            }
            if (d2 + d3 <= d4) {
                d3 = 0.0;
                d4 = d2 += d3;
                for (n = 0; n < 3; ++n) {
                    this.m_bary[n].m_data[n2] = this.m_v[1].m_data[n];
                }
                piVector.m_data[n2] = n6;
                bl = true;
            } else {
                double d7 = (d4 - d2) / d3;
                for (n7 = 0; n7 < 3; ++n7) {
                    this.m_bary[n7].m_data[n2] = d7 * this.m_diff.m_data[n7] + this.m_v[0].m_data[n7];
                }
                piVector.m_data[n2] = n6;
            }
            if (++n2 < n4) continue;
            n4 += n5;
            for (n = 0; n < 3; ++n) {
                this.m_bary[n].setSize(n4);
            }
            piVector.setSize(n4);
        }
        for (n = 0; n < 3; ++n) {
            this.m_bary[n].setSize(n2);
        }
        piVector.setSize(n2);
        return d2 - d5;
    }

    public int eval(PdVector[] pdVectorArray, PiVector piVector, double d) {
        int n;
        int n2;
        int n3;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing geometry (forgot call of 'setGeometry(..)'?).");
            return 0;
        }
        if (((PgPointSet)this).m_numVertices < 1) {
            return 0;
        }
        int n4 = pdVectorArray[0].getSize();
        if (n4 < 2) {
            n4 = 100;
        }
        for (n3 = 0; n3 < 3; ++n3) {
            pdVectorArray[n3].setSize(n4);
        }
        piVector.setSize(n4);
        n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n5 = 0;
        if (this.m_v == null) {
            this.m_v = PdBary.realloc(null, (int)2, (int)3);
        }
        PdBary pdBary = this.m_v[0];
        PdBary pdBary2 = this.m_v[1];
        if (this.m_star == null) {
            this.m_star = new PgVertexStar[2];
            this.m_star[0] = new PgVertexStar();
            this.m_star[1] = new PgVertexStar();
        }
        for (n2 = 0; n2 < 3; ++n2) {
            pdVectorArray[n2].m_data[0] = this.m_vertexBary[0].m_data[n2];
        }
        piVector.m_data[0] = this.m_vertexBary[0].m_elementInd;
        n2 = 1;
        while (true) {
            int n6;
            d4 += d;
            while (d2 + d3 <= d4 && n3 + 1 < ((PgPointSet)this).m_numVertices) {
                d2 += d3;
                pdBary = this.m_vertexBary[n3];
                n5 = pdBary.m_elementInd;
                pdBary2 = this.m_vertexBary[n3 + 1];
                if (n5 != pdBary2.m_elementInd) {
                    int n7;
                    int n8;
                    n = -1;
                    int n9 = -1;
                    n6 = 0;
                    for (n8 = 0; n8 < 3; ++n8) {
                        if (Math.abs(pdBary2.m_data[n8]) > 1.0E-10) {
                            n = n8;
                            continue;
                        }
                        ++n6;
                        n9 = n8;
                    }
                    n8 = n6 == 2 ? 1 : 0;
                    boolean bl = n6 == 1;
                    int n10 = pdBary2.m_elementInd;
                    if (bl) {
                        if (n5 != this.m_geom.getNeighbour((int)n10).m_data[n9]) {
                            PsDebug.warning((String)"Consecutive elements must be neighbors.");
                            return 0;
                        }
                        n7 = this.m_geom.getOppVertexLocInd(n10, n9);
                        this.m_v[1].m_data[n7] = 0.0;
                        this.m_v[1].m_data[(n7 + 1) % 3] = pdBary2.m_data[(n9 + 2) % 3];
                        this.m_v[1].m_data[(n7 + 2) % 3] = pdBary2.m_data[(n9 + 1) % 3];
                        this.m_v[1].m_elementInd = pdBary.m_elementInd;
                    } else if (n8 != 0) {
                        this.m_star[1].makeVertexStar(this.m_geom, this.m_geom.getElement((int)n10).m_data[n], n10);
                        int[] nArray = this.m_star[1].getElement().m_data;
                        for (n7 = nArray.length - 1; n7 >= 0 && nArray[n7] != n10; --n7) {
                        }
                        if (n7 == -1) {
                            PsDebug.warning((String)"Consecutive elements must be neighbors.");
                            return 0;
                        }
                        int n11 = this.m_star[1].getVertexLocInd().m_data[n7];
                        this.m_v[1].copy(PdBary.TRIANGLE_VERTEX[n11]);
                    } else {
                        PsDebug.warning((String)"Cannot do it in barycoords.");
                        return 0;
                    }
                    pdBary2 = this.m_v[1];
                    pdBary2.m_elementInd = pdBary.m_elementInd;
                }
                this.m_diff.sub(pdBary2, pdBary);
                d3 = PwBary.norm(this.m_geom, n5, this.m_diff, n2 == 0);
                ++n3;
            }
            if (d2 + d3 <= d4) break;
            double d5 = (d4 - d2) / d3;
            for (n6 = 0; n6 < 3; ++n6) {
                pdVectorArray[n6].m_data[n2] = d5 * this.m_diff.m_data[n6] + pdBary.m_data[n6];
            }
            piVector.m_data[n2] = n5;
            if (++n2 < n4) continue;
            n4 += 100;
            for (n6 = 0; n6 < 3; ++n6) {
                pdVectorArray[n6].setSize(n4);
            }
            piVector.setSize(n4);
        }
        for (n = 0; n < 3; ++n) {
            pdVectorArray[n].m_data[n2] = pdBary2.m_data[n];
        }
        piVector.m_data[n2] = n5;
        return ++n2;
    }

    public PgPolygon getPolygon() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing element set.");
            return null;
        }
        PgPolygon pgPolygon = new PgPolygon(this.m_geom.getDimOfVertices());
        this.getPolygon(pgPolygon);
        return pgPolygon;
    }

    public boolean getPolygon(PgPolygon pgPolygon) {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing element set.");
            return false;
        }
        if (pgPolygon == null) {
            PsDebug.warning((String)"Missing polygon.");
            return false;
        }
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        int n = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        pgPolygon.setDimOfVertices(((PgGeometry)this).m_dim);
        pgPolygon.setNumVertices(((PgPointSet)this).m_numVertices);
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            int n2 = this.m_vertexBary[i].m_elementInd;
            if (n <= n2 || n2 <= -1) {
                pgPolygon.setNumVertices(i);
                PsDebug.warning((String)("Element index " + n2 + " out of bounds: vertex" + i + "."));
                return false;
            }
            int[] nArray = piVectorArray[n2].m_data;
            this.m_vertexBary[i].getVertex(pdVector, this.m_geom.getVertex(nArray[0]), this.m_geom.getVertex(nArray[1]), this.m_geom.getVertex(nArray[2]));
            pgPolygon.setVertex(i, pdVector);
        }
        return true;
    }

    public PdBary swap(PgPolygonOnElementSet pgPolygonOnElementSet, int n, int n2, int n3) {
        int n4 = n + n3;
        if (pgPolygonOnElementSet.getNumVertices() < n2 + n3) {
            pgPolygonOnElementSet.setNumVertices(n2 + n3);
        }
        if (((PgPointSet)this).m_numVertices < n4) {
            this.setNumVertices(n4);
        }
        PdBary[] pdBaryArray = pgPolygonOnElementSet.getVertexBary();
        PdBary pdBary = null;
        while (n < n4) {
            pdBary = pdBaryArray[n2];
            pdBaryArray[n2] = this.m_vertexBary[n];
            this.m_vertexBary[n] = pdBary;
            ++n;
            ++n2;
        }
        return pdBary;
    }

    public void swap(int n, int n2) {
        PdBary pdBary = this.m_vertexBary[n];
        this.m_vertexBary[n] = this.m_vertexBary[n2];
        this.m_vertexBary[n2] = pdBary;
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        int n = this.getNumVertices();
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgPolygonOnElementSet)) {
            return false;
        }
        PgPolygonOnElementSet pgPolygonOnElementSet = (PgPolygonOnElementSet)pgGeometryIf;
        int n2 = pgPolygonOnElementSet.getNumVertices();
        if (n + n2 != ((PgPointSet)this).m_numVertices) {
            --n;
        }
        PdBary.copy((PdBary[])this.m_vertexBary, (int)n, (PdBary[])pgPolygonOnElementSet.getVertexBary(), (int)0, (int)n2);
        return true;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPolygonOnElementSet) || !(pgGeometry2 instanceof PgPolygonOnElementSet)) {
            return false;
        }
        PgPolygonOnElementSet pgPolygonOnElementSet = (PgPolygonOnElementSet)pgGeometry;
        PgPolygonOnElementSet pgPolygonOnElementSet2 = (PgPolygonOnElementSet)pgGeometry2;
        int n = pgPolygonOnElementSet.getNumVertices();
        for (int i = 0; i < n; ++i) {
            pgPolygonOnElementSet.m_vertexBary[i].blend(d, pgPolygonOnElementSet.m_vertexBary[i], d2, pgPolygonOnElementSet2.m_vertexBary[i]);
        }
        return true;
    }

    public void setAccuracy(double d) {
        this.m_eps = Math.abs(d);
        if (this.m_exp != null) {
            this.m_exp.setAccuracy(d);
        }
    }

    public void flipOrientation() {
        super.flipOrientation();
        if (this.m_vertexBary != null) {
            P_Vector.invert((Object[])this.m_vertexBary, (int)((PgPointSet)this).m_numVertices);
        }
    }

    public static PdBaryDir[] projectCurveOntoElementSet(PgElementSet pgElementSet, PgPolygon pgPolygon, PdBary pdBary, PgPolygonOnElementSet pgPolygonOnElementSet) {
        int n;
        PdVector pdVector;
        int n2;
        int n3;
        if (pgPolygonOnElementSet != null) {
            pgPolygonOnElementSet.setGeometry(pgElementSet);
            pgPolygonOnElementSet.setName("Projected " + pgPolygon.getName());
        }
        int n4 = pgPolygon.getNumVertices();
        int n5 = pgPolygon.getNumEdges();
        boolean bl = pgPolygon.isClosed();
        if (n4 == 0) {
            return new PdBaryDir[0];
        }
        PdBary pdBary2 = pdBary;
        if (pdBary2.isOnEdge() != -1) {
            PdBary[] pdBaryArray = PwBary.getBaryDescriptions(pgElementSet, pdBary2, 1.0E-10);
            double d = Double.POSITIVE_INFINITY;
            n3 = -1;
            for (int i = 0; i < pdBaryArray.length; ++i) {
                int n6 = pdBaryArray[i].getElementInd();
                double d2 = Math.abs(PuVectorGeom.distOfPointToPlane((PdVector)pgPolygon.getVertex(1), (PdVector)pgElementSet.getVertex(pgElementSet.getElement((int)n6).m_data[0]), (PdVector)pgElementSet.getElementNormal(n6)));
                if (!(d2 < d)) continue;
                d = d2;
                n3 = i;
            }
            pdBary2 = pdBaryArray[n3];
        }
        int n7 = 8;
        PdBary[] pdBaryArray = new PdBary[n7];
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[n7];
        n3 = 1;
        pdBaryArray[0] = PdBary.copyNew((PdBary)pdBary2);
        PdBary pdBary3 = new PdBary(3);
        pdBary3.copy(pdBaryArray[0]);
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdBary pdBary4 = new PdBary(3);
        int n8 = pdBary2.getElementInd();
        block1: for (n2 = 0; n2 < n5; ++n2) {
            double d;
            int n9 = (n2 + 1) % n4;
            pdVector = pgPolygon.getVertex(n9);
            n = -1;
            do {
                d = 1.0;
                PwBary.projectOntoElement(pgElementSet, n8, pdVector, pdBary4);
                pdBaryDir.sub(pdBary4, pdBary2);
                int n10 = -1;
                for (int i = 0; i < 3; ++i) {
                    double d3 = -pdBary2.m_data[i] / pdBaryDir.m_data[i];
                    if (!(pdBaryDir.m_data[i] < 0.0) || !(d3 >= 0.0) || !(d3 <= d + 1.0E-10)) continue;
                    d = Math.min(d3, 1.0);
                    n10 = i;
                }
                pdBaryDir.multScalar(d);
                pdBary2.add(pdBaryDir);
                if (n10 < 0) continue;
                if (pdBaryDir.m_data[0] * pdBaryDir.m_data[0] + pdBaryDir.m_data[1] * pdBaryDir.m_data[1] + pdBaryDir.m_data[2] * pdBaryDir.m_data[2] > 1.0E-10) {
                    if (n3 == n7) {
                        pdBaryArray = PdBary.realloc((PdBary[])pdBaryArray, (int)(n7 *= 2), (int)3);
                        pdBaryDirArray = PdBaryDir.realloc((PdBaryDir[])pdBaryDirArray, (int)n7, (int)3);
                    }
                    pdBaryArray[n3] = PdBary.copyNew((PdBary)pdBary2);
                    if (pdBary3 != null) {
                        pdBaryDirArray[n3] = new PdBaryDir(3);
                        pdBaryDirArray[n3].sub(pdBary2, pdBary3);
                    }
                    ++n3;
                }
                PiVector piVector = pgElementSet.getElement(n8);
                int n11 = pgElementSet.getNeighbour((int)n8).m_data[n10];
                if (n11 < 0) {
                    PsDebug.warning((String)"Polygon cutted at surface boundary.");
                    bl = false;
                    n2 = n5 + 1;
                    continue block1;
                }
                PiVector piVector2 = pgElementSet.getElement(n11);
                if (n11 == n) continue block1;
                n = n8;
                int n12 = (n10 + 1) % 3;
                int n13 = piVector2.getIndexOf(piVector.m_data[n12]);
                int n14 = (n10 + 2) % 3;
                int n15 = piVector2.getIndexOf(piVector.m_data[n14]);
                PdBary pdBary5 = new PdBary(0.0, 0.0, 0.0);
                pdBary5.m_data[n13] = pdBary2.m_data[n12];
                pdBary5.m_data[n15] = pdBary2.m_data[n14];
                pdBary2.copy(pdBary5);
                n8 = n11;
                pdBary2.setElementInd(n8);
                pdBary3.copy(pdBary2);
            } while (!(d >= 1.0));
        }
        n2 = 0;
        n5 = n3++;
        PdBary pdBary6 = pdBary2;
        pdVector = new PdBaryDir(3);
        pdVector.sub(pdBary6, pdBary3);
        if (bl) {
            if (pdBaryArray[0].isOnEdge() == 0) {
                --n3;
            } else {
                n2 = 1;
                n3 -= 2;
                --n5;
            }
            pdBary6 = pdBaryArray[n3 - 1];
            pdVector = pdBaryDirArray[n5];
        }
        if (pgPolygonOnElementSet != null) {
            pgPolygonOnElementSet.setNumVertices(n3);
            for (n = 0; n < n3 - 1; ++n) {
                pgPolygonOnElementSet.setVertexBary(n, pdBaryArray[n2].getElementInd(), pdBaryArray[n2]);
                ++n2;
            }
            pgPolygonOnElementSet.setVertexBary(n3 - 1, pdBary6.getElementInd(), pdBary6);
            pgPolygonOnElementSet.setClosed(bl);
        }
        PdBaryDir[] pdBaryDirArray2 = new PdBaryDir[n5];
        System.arraycopy(pdBaryDirArray, 1, pdBaryDirArray2, 0, n5 - 1);
        pdBaryDirArray2[n5 - 1] = pdVector;
        return pdBaryDirArray2;
    }

    public static PdBaryDir[] projectCurveOntoElementSet(PgElementSet pgElementSet, PgPolygon pgPolygon, PgPolygonOnElementSet pgPolygonOnElementSet) {
        if (pgPolygon.getNumVertices() == 0) {
            return new PdBaryDir[0];
        }
        PdBary pdBary = PwBary.projectOntoElementSet(pgElementSet, pgPolygon.getVertex(0), null);
        if (pdBary == null) {
            return null;
        }
        return PgPolygonOnElementSet.projectCurveOntoElementSet(pgElementSet, pgPolygon, pdBary, pgPolygonOnElementSet);
    }

    public PdBaryDir exp(int n, PdBary pdBary, PdBaryDir pdBaryDir, double d) {
        return this.exp(n, pdBary, pdBaryDir, d, null);
    }

    public PdBaryDir exp(int n, PdBary pdBary, PdBaryDir pdBaryDir, double d, PgPolygon pgPolygon) {
        PdBaryDir pdBaryDir2 = (PdBaryDir)pdBaryDir.clone();
        pdBaryDir2.multScalar(d);
        pdBary.m_elementInd = n;
        if (this.m_exp == null) {
            this.m_exp = new PnStraightestGeodesic(this.m_geom, false);
            this.m_exp.setAccuracy(this.m_eps);
        }
        this.m_exp.eval(pdBary, pdBaryDir2, this, pdBaryDir2);
        if (pgPolygon != null) {
            this.getPolygon(pgPolygon);
        }
        return pdBaryDir2;
    }

    public PdBary[] getBary() {
        return this.getVertexBary();
    }

    public PdBary getBary(int n) {
        return this.getVertexBary(n);
    }

    public int getElemInd(int n) {
        return this.getVertexElemInd(n);
    }

    public PiVector getElemInd() {
        return this.getVertexElemInd();
    }

    public void addPolygon(PgPolygonOnElementSet pgPolygonOnElementSet) {
        this.merge((PgGeometryIf)pgPolygonOnElementSet);
    }

    public void setBary(int n, int n2, PdBary pdBary) {
        this.setVertexBary(n, n2, pdBary);
    }

    public void setVertex(int n, int n2, PdBary pdBary) {
        this.setVertexBary(n, n2, pdBary);
    }

    public void setVertex(int n, PdBary pdBary) {
        this.setVertexBary(n, pdBary);
    }

    public void updateVertices() {
        int n = this.m_geom.getDimOfVertices();
        if (n < 0) {
            PsDebug.warning((String)"Element set must have a uniform vertex dimension.");
            return;
        }
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            if (this.m_vertexBary[i] == null) continue;
            if (((PgPointSet)this).m_vertex[i] == null) {
                ((PgPointSet)this).m_vertex[i] = new PdVector(n);
            }
            PwBary.getVertex(((PgPointSet)this).m_vertex[i], this.m_geom, this.m_vertexBary[i]);
        }
    }

    public int[] removeMarkedVertices() {
        int n = -1;
        int n2 = this.getNumVertices();
        PdBary[] pdBaryArray = this.m_vertexBary;
        int[] nArray = super.removeMarkedVertices();
        if (this.m_vertexBary != null) {
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] == n || nArray[i] >= i) continue;
                this.m_vertexBary[nArray[i]] = pdBaryArray[i];
            }
        }
        return nArray;
    }

    public void computeNormalCurvature() {
        PgElementSet pgElementSet = this.getGeometry();
        PdMatrix[] pdMatrixArray = PwCurvature.getShapeOperator(pgElementSet, null, false);
        PnMassMatrix.multInvMassMatrix(pgElementSet, pdMatrixArray, true);
        PgVectorField pgVectorField = PgPolygonOnElementSet.getNormalCurvature(this, pdMatrixArray, null);
        this.addVectorField(pgVectorField);
    }

    public static PgVectorField getNormalCurvature(PgPolygonOnElementSet pgPolygonOnElementSet, PdMatrix[] pdMatrixArray, PgVectorField pgVectorField) {
        if (pgPolygonOnElementSet == null || pdMatrixArray == null) {
            PsDebug.warning((String)"given argument is null");
            return null;
        }
        int n = pgPolygonOnElementSet.getNumVertices();
        int n2 = pgPolygonOnElementSet.getDimOfVertices();
        PdVector[] pdVectorArray = pgPolygonOnElementSet.getVertices();
        PdVector pdVector = new PdVector(n2);
        PdVector pdVector2 = new PdVector(n2);
        PdMatrix pdMatrix = new PdMatrix(n2);
        PdBary[] pdBaryArray = pgPolygonOnElementSet.getVertexBary();
        PiVector piVector = pgPolygonOnElementSet.getVertexElemInd();
        PgElementSet pgElementSet = pgPolygonOnElementSet.getGeometry();
        PiVector[] piVectorArray = pgElementSet.getElements();
        if (pdMatrixArray.length < pgElementSet.getNumVertices()) {
            PsDebug.warning((String)"the size of the array shapeOperator is to small");
            return null;
        }
        if (pgVectorField == null) {
            pgVectorField = new PgVectorField(1, 0);
            pgVectorField.setGeometry((PgPointSet)pgPolygonOnElementSet);
        } else {
            if (pgVectorField.getBasedOn() != 0) {
                pgVectorField.setBasedOn(0);
            }
            if (pgVectorField.getGeometry() != pgPolygonOnElementSet) {
                pgVectorField.setGeometry((PgPointSet)pgPolygonOnElementSet);
            }
        }
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                if (pgPolygonOnElementSet.isClosed()) {
                    pdVector.sub(pdVectorArray[1], pdVectorArray[n - 1]);
                } else {
                    pdVector.sub(pdVectorArray[1], pdVectorArray[0]);
                }
            } else if (i == n - 1) {
                if (pgPolygonOnElementSet.isClosed()) {
                    pdVector.sub(pdVectorArray[0], pdVectorArray[n - 2]);
                } else {
                    pdVector.sub(pdVectorArray[n - 1], pdVectorArray[n - 2]);
                }
            } else {
                pdVector.sub(pdVectorArray[i + 1], pdVectorArray[i - 1]);
            }
            pdVector.normalize();
            PiVector piVector2 = piVectorArray[piVector.m_data[i]];
            pdMatrix.blend(pdBaryArray[i], pdMatrixArray[piVector2.m_data[0]], pdMatrixArray[piVector2.m_data[1]], pdMatrixArray[piVector2.m_data[2]]);
            pdVector2.leftMultMatrix(pdMatrix, pdVector);
            pgVectorField.setVector(i, PdVector.dot((PdVector)pdVector2, (PdVector)pdVector));
        }
        return pgVectorField;
    }

    public void makeNormalsFromSurfaceNormals() {
        PgPolygonOnElementSet.makeNormalsFromSurfaceNormals(this);
    }

    public static void makeNormalsFromSurfaceNormals(PgPolygonOnElementSet pgPolygonOnElementSet) {
        if (pgPolygonOnElementSet == null) {
            PsDebug.warning((String)"given argument is null");
            return;
        }
        int n = pgPolygonOnElementSet.getNumVertices();
        int n2 = pgPolygonOnElementSet.getDimOfVertices();
        pgPolygonOnElementSet.assureVertexNormals();
        PdVector[] pdVectorArray = pgPolygonOnElementSet.getVertexNormals();
        PdBary[] pdBaryArray = pgPolygonOnElementSet.getVertexBary();
        PiVector piVector = pgPolygonOnElementSet.getVertexElemInd();
        PgElementSet pgElementSet = pgPolygonOnElementSet.getGeometry();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertexNormals();
        PdVector pdVector = new PdVector(n2);
        for (int i = 0; i < n; ++i) {
            PiVector piVector2 = piVectorArray[piVector.m_data[i]];
            int n3 = piVector2.getSize();
            for (int j = 0; j < n3; ++j) {
                pdVector.blend(pdBaryArray[i].m_data[0], pdVectorArray2[piVector2.m_data[0]], pdBaryArray[i].m_data[1], pdVectorArray2[piVector2.m_data[1]], pdBaryArray[i].m_data[2], pdVectorArray2[piVector2.m_data[2]]);
            }
            pdVector.normalize();
            pdVectorArray[i].copyArray(pdVector);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

