/*
 * Decompiled with CFR 0.152.
 */
package jvx.cellular;

import java.awt.Color;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Random;
import jv.geom.PgElementSet;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwSnake
extends PjWorkshop
implements KeyListener,
Runnable {
    private Thread m_thread;
    protected int m_sleepTime = 100;
    protected boolean m_bAlive;
    private int m_headPosition = 0;
    private int m_oldPosition;
    private int m_tailPosition = 0;
    private int m_oldTailPosition;
    private int m_foodPosition = -1;
    protected Random m_random;
    private int m_noe = 0;
    private int m_nov = 0;
    private Color[] m_faceColor;
    protected boolean m_bSmoothColoring = true;
    private Color[] m_smoothSnakeColor;
    private Color m_emptyColor = new Color(255, 255, 255);
    protected PdColor m_emptyPdColor = new PdColor();
    private Color m_snakeTailColor = new Color(255, 255, 0);
    protected PdColor m_snakeTailPdColor = new PdColor();
    private Color m_snakeHeadColor = new Color(0, 0, 85);
    protected PdColor m_snakeHeadPdColor = new PdColor();
    private Color m_foodColor = new Color(255, 0, 0);
    protected PdColor m_foodPdColor = new PdColor();
    private boolean m_bRPressed = false;
    private boolean m_bLPressed = false;
    private int m_direction;
    private int m_summand;
    private PiVector m_neigh;
    private int m_neighSize = 3;
    private int[] m_vertexValence;
    private int[] m_nextEl;
    private int m_length = 0;
    private int m_addLength;
    private static int m_startLength = 12;
    protected TextField m_tLength;
    private int m_currentKey = 0;
    private int m_numKeys = 0;
    private static int m_maxNumKeys = 4;
    private static boolean RIGHT = true;
    private static boolean LEFT = false;
    private boolean[] m_key = new boolean[m_maxNumKeys];
    protected boolean m_bUpdateCamera;
    protected boolean m_bPause = false;
    private PdVector m_edgeMidPoint = new PdVector(3);
    private PdVector m_oldEdgeMidPoint = new PdVector(3);
    private PdVector m_center = new PdVector(3);
    private PdVector m_viewDir = new PdVector(3);
    private PdVector m_upVector = new PdVector(3);
    static /* synthetic */ Class class$jvx$cellular$PwSnake;

    public PwSnake() {
        super("Snake");
        this.m_random = new Random();
        this.m_tLength = new TextField("0", 8);
        this.m_tLength.setEditable(false);
        if (this.getClass() == (class$jvx$cellular$PwSnake == null ? (class$jvx$cellular$PwSnake = PwSnake.class$("jvx.cellular.PwSnake")) : class$jvx$cellular$PwSnake)) {
            this.init();
        }
    }

    public void init() {
        this.m_emptyPdColor.setName("Empty");
        this.m_emptyPdColor.setColor(this.m_emptyColor);
        this.m_emptyPdColor.addUpdateListener((PsUpdateIf)this);
        this.m_snakeTailPdColor.setName("Tail");
        this.m_snakeTailPdColor.setColor(this.m_snakeTailColor);
        this.m_snakeTailPdColor.addUpdateListener((PsUpdateIf)this);
        this.m_snakeHeadPdColor.setName("Head");
        this.m_snakeHeadPdColor.setColor(this.m_snakeHeadColor);
        this.m_snakeHeadPdColor.addUpdateListener((PsUpdateIf)this);
        this.m_foodPdColor.setName("Food");
        this.m_foodPdColor.setColor(this.m_foodColor);
        this.m_foodPdColor.addUpdateListener((PsUpdateIf)this);
        super.init();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        this.m_nov = ((PgElementSet)this.m_geom).getNumVertices();
        this.m_noe = ((PgElementSet)this.m_geom).getNumElements();
        this.m_vertexValence = new int[this.m_nov];
        this.m_nextEl = new int[this.m_noe];
        for (int i = 0; i < this.m_noe; ++i) {
            this.m_nextEl[i] = -1;
            this.m_neigh = ((PgElementSet)this.m_geom).getElement(i);
            this.m_neighSize = this.m_neigh.getSize();
            for (int j = 0; j < this.m_neighSize; ++j) {
                int n = this.m_neigh.m_data[j];
                this.m_vertexValence[n] = this.m_vertexValence[n] + 1;
            }
        }
        this.m_faceColor = new Color[this.m_noe];
        this.m_smoothSnakeColor = new Color[this.m_noe];
        ((PgElementSet)this.m_geom).showElementColors(true);
    }

    public void reset() {
        int n;
        this.m_bAlive = false;
        while (this.m_thread != null) {
        }
        this.m_smoothSnakeColor[0] = this.m_snakeHeadColor;
        for (n = 0; n < this.m_noe; ++n) {
            this.m_faceColor[n] = this.m_emptyColor;
            this.m_nextEl[n] = -1;
        }
        ((PgElementSet)this.m_geom).setElementColors(this.m_faceColor);
        n = Math.abs(this.m_random.nextInt()) % this.m_noe;
        this.m_faceColor[n] = this.m_snakeHeadColor;
        this.m_headPosition = n;
        this.m_oldPosition = n;
        this.m_tailPosition = n;
        this.m_oldTailPosition = n;
        this.m_neigh = ((PgElementSet)this.m_geom).getNeighbour(this.m_headPosition);
        this.m_neighSize = this.m_neigh.getSize();
        this.setFood();
        this.m_length = 1;
        this.m_addLength = m_startLength - 1;
        ((TextComponent)this.m_tLength).setText("" + this.m_length);
        this.m_direction = n = Math.abs(this.m_random.nextInt()) % this.m_neighSize;
        this.m_summand = 0;
        this.m_currentKey = 0;
        this.m_numKeys = 0;
    }

    public boolean update(Object object) {
        if (object == this.m_emptyPdColor) {
            this.m_emptyColor = this.m_emptyPdColor.getColor();
            for (int i = 0; i < this.m_noe; ++i) {
                if (this.m_nextEl[i] != -1 || i == this.m_headPosition || i == this.m_foodPosition) continue;
                ((PgElementSet)this.m_geom).setElementColor(i, this.m_emptyColor);
            }
            this.m_geom.update(null);
        } else if (object == this.m_snakeTailPdColor) {
            this.m_snakeTailColor = this.m_snakeTailPdColor.getColor();
            int n = this.m_tailPosition;
            this.makeSnakeColor();
            for (int i = 0; i < this.m_length; ++i) {
                ((PgElementSet)this.m_geom).setElementColor(n, this.m_smoothSnakeColor[i]);
                n = this.m_nextEl[n];
            }
            this.m_geom.update(null);
        } else if (object == this.m_snakeHeadPdColor) {
            this.m_snakeHeadColor = this.m_snakeHeadPdColor.getColor();
            int n = this.m_tailPosition;
            this.makeSnakeColor();
            for (int i = 0; i < this.m_length; ++i) {
                ((PgElementSet)this.m_geom).setElementColor(n, this.m_smoothSnakeColor[i]);
                n = this.m_nextEl[n];
            }
            this.m_geom.update(null);
        } else if (object == this.m_foodPdColor) {
            this.m_foodColor = this.m_foodPdColor.getColor();
            if (this.m_foodPosition != -1) {
                ((PgElementSet)this.m_geom).setElementColor(this.m_foodPosition, this.m_foodColor);
            }
            this.m_geom.update(null);
        }
        return super.update(object);
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        super.setDisplay(pvDisplayIf);
        pvDisplayIf.addKeyListener((KeyListener)this);
    }

    public void close() {
        this.m_bAlive = false;
        while (this.m_thread != null) {
        }
        if (this.m_geomSave != null) {
            this.m_geom.copy((PsObject)this.m_geomSave);
            this.m_geom.update((Object)this.m_geom);
        }
        this.m_display.removeKeyListener((KeyListener)this);
        super.close();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (39 == keyEvent.getKeyCode()) {
            if (!this.m_bRPressed) {
                this.m_bRPressed = true;
                this.m_key[(this.m_currentKey + this.m_numKeys) % PwSnake.m_maxNumKeys] = RIGHT;
                if (this.m_numKeys == m_maxNumKeys) {
                    this.m_currentKey = (this.m_currentKey + 1) % m_maxNumKeys;
                } else {
                    ++this.m_numKeys;
                }
            }
        } else if (37 == keyEvent.getKeyCode() && !this.m_bLPressed) {
            this.m_bLPressed = true;
            this.m_key[(this.m_currentKey + this.m_numKeys) % PwSnake.m_maxNumKeys] = LEFT;
            if (this.m_numKeys == m_maxNumKeys) {
                this.m_currentKey = (this.m_currentKey + 1) % m_maxNumKeys;
            } else {
                ++this.m_numKeys;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (39 == keyEvent.getKeyCode()) {
            this.m_bRPressed = false;
        } else if (37 == keyEvent.getKeyCode()) {
            this.m_bLPressed = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void step() {
        int n;
        int n2;
        if (this.m_neighSize % 2 == 1) {
            this.m_direction += this.m_summand;
            this.m_summand = (this.m_summand + 1) % 2;
        }
        if (this.m_numKeys > 0) {
            if (this.m_key[this.m_currentKey] == RIGHT) {
                if (this.m_neigh.m_data[(this.m_direction + this.m_neighSize - 1) % this.m_neighSize] != this.m_oldPosition) {
                    this.m_direction += this.m_neighSize - 1;
                    --this.m_numKeys;
                    this.m_currentKey = (this.m_currentKey + 1) % m_maxNumKeys;
                    if (this.m_neighSize == 3) {
                        this.m_summand = (this.m_summand + 1) % 2;
                    }
                }
            } else if (this.m_neigh.m_data[(this.m_direction + 1) % this.m_neighSize] != this.m_oldPosition) {
                ++this.m_direction;
                --this.m_numKeys;
                this.m_currentKey = (this.m_currentKey + 1) % m_maxNumKeys;
                if (this.m_neighSize == 3) {
                    this.m_summand = (this.m_summand + 1) % 2;
                }
            }
        }
        this.m_oldPosition = this.m_headPosition;
        if (this.m_neigh.m_data[this.m_direction % this.m_neighSize] == -1 || this.m_nextEl[this.m_neigh.m_data[this.m_direction % this.m_neighSize]] != -1 && this.m_neigh.m_data[this.m_direction % this.m_neighSize] != this.m_tailPosition) {
            this.die();
            return;
        }
        int n3 = this.m_direction % this.m_neighSize;
        this.m_nextEl[this.m_oldPosition] = this.m_headPosition = this.m_neigh.m_data[this.m_direction % this.m_neighSize];
        this.m_neigh = ((PgElementSet)this.m_geom).getNeighbour(this.m_headPosition);
        this.m_neighSize = this.m_neigh.getSize();
        for (n2 = 0; n2 < this.m_neighSize; ++n2) {
            if (this.m_neigh.m_data[n2] != this.m_oldPosition) continue;
            if (this.m_neighSize == 3 && this.m_vertexValence[((PgElementSet)this.m_geom).getElement((int)this.m_headPosition).m_data[(n2 + 2) % 3]] > 5 && this.m_vertexValence[((PgElementSet)this.m_geom).getElement((int)this.m_headPosition).m_data[(n2 + 1) % 3]] < 5 && this.m_summand == 1 || this.m_vertexValence[((PgElementSet)this.m_geom).getElement((int)this.m_headPosition).m_data[(n2 + 1) % 3]] > 5 && this.m_vertexValence[((PgElementSet)this.m_geom).getElement((int)this.m_headPosition).m_data[(n2 + 2) % 3]] < 5 && this.m_summand == 0) {
                this.m_summand = (this.m_summand + 1) % 2;
            }
            this.m_direction = n2 + this.m_neighSize / 2;
            break;
        }
        if (this.m_headPosition == this.m_foodPosition && this.setFood()) {
            ++this.m_addLength;
        }
        if (this.m_addLength == 0) {
            ((PgElementSet)this.m_geom).setElementColor(this.m_tailPosition, this.m_emptyColor);
            this.m_oldTailPosition = this.m_tailPosition;
            this.m_tailPosition = this.m_nextEl[this.m_oldTailPosition];
            this.m_nextEl[this.m_oldTailPosition] = -1;
        } else {
            --this.m_addLength;
            ++this.m_length;
            ((TextComponent)this.m_tLength).setText("" + this.m_length);
            if (this.m_bSmoothColoring) {
                this.makeSnakeColor();
            }
        }
        if (this.m_bSmoothColoring) {
            n2 = this.m_tailPosition;
            for (n = 0; n < this.m_length; ++n) {
                ((PgElementSet)this.m_geom).setElementColor(n2, this.m_smoothSnakeColor[n]);
                n2 = this.m_nextEl[n2];
            }
        } else {
            ((PgElementSet)this.m_geom).setElementColor(this.m_headPosition, this.m_snakeHeadColor);
            ((PgElementSet)this.m_geom).setElementColor(this.m_oldPosition, this.m_snakeTailColor);
        }
        if (this.m_bUpdateCamera) {
            PiVector piVector = this.m_geom.getElement(this.m_oldPosition);
            n = piVector.getSize();
            PdVector pdVector = this.m_geom.getVertex(piVector.m_data[(n3 + 1) % n]);
            PdVector pdVector2 = this.m_geom.getVertex(piVector.m_data[(n3 + 2) % n]);
            this.m_edgeMidPoint.copy(pdVector);
            this.m_edgeMidPoint.add(pdVector2);
            this.m_edgeMidPoint.multScalar(0.5);
            this.getCenterOfElement(this.m_headPosition, this.m_center);
            this.m_viewDir.copy(((PgElementSet)this.m_geom).getElementNormal(this.m_headPosition));
            this.m_viewDir.multScalar(-1.0);
            this.m_upVector.copy(this.m_edgeMidPoint);
            this.m_upVector.sub(this.m_oldEdgeMidPoint);
            this.m_upVector.normalize();
            PvCameraIf pvCameraIf = this.getDisplay().getCamera();
            pvCameraIf.setInterest(this.m_center);
            pvCameraIf.setViewDir(this.m_viewDir);
            pvCameraIf.setUpVector(this.m_upVector);
            this.m_oldEdgeMidPoint.copy(this.m_edgeMidPoint);
        }
        this.m_geom.update(null);
    }

    private void makeSnakeColor() {
        float[] fArray = Color.RGBtoHSB(this.m_snakeTailColor.getRed(), this.m_snakeTailColor.getGreen(), this.m_snakeTailColor.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(this.m_snakeHeadColor.getRed(), this.m_snakeHeadColor.getGreen(), this.m_snakeHeadColor.getBlue(), null);
        for (int i = 0; i < this.m_length; ++i) {
            this.m_smoothSnakeColor[i] = Color.getHSBColor(((float)i * fArray2[0] + (float)(this.m_length - i - 1) * fArray[0]) / (float)(this.m_length - 1), ((float)i * fArray2[1] + (float)(this.m_length - i - 1) * fArray[1]) / (float)(this.m_length - 1), ((float)i * fArray2[2] + (float)(this.m_length - i - 1) * fArray[2]) / (float)(this.m_length - 1));
        }
    }

    private PdVector getCenterOfElement(int n, PdVector pdVector) {
        if (pdVector == null) {
            pdVector = new PdVector(3);
        }
        PiVector piVector = this.m_geom.getElement(n);
        int n2 = piVector.getSize();
        for (int i = 0; i < n2; ++i) {
            pdVector.add(this.m_geom.getVertex(piVector.m_data[i]));
        }
        pdVector.multScalar(1.0 / (double)n2);
        return pdVector;
    }

    private void die() {
        this.m_bAlive = false;
        for (int i = 0; i < 5; ++i) {
            int n;
            for (int j = 0; j < this.m_noe; ++j) {
                if (this.m_nextEl[j] != -1) {
                    ((PgElementSet)this.m_geom).setElementColor(j, this.m_emptyColor);
                    continue;
                }
                ((PgElementSet)this.m_geom).setElementColor(j, this.m_snakeTailColor);
            }
            ((PgElementSet)this.m_geom).setElementColor(this.m_headPosition, this.m_foodColor);
            this.m_geom.update(null);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (n = 0; n < this.m_noe; ++n) {
                if (this.m_nextEl[n] != -1) {
                    ((PgElementSet)this.m_geom).setElementColor(n, this.m_snakeTailColor);
                    continue;
                }
                ((PgElementSet)this.m_geom).setElementColor(n, this.m_emptyColor);
            }
            ((PgElementSet)this.m_geom).setElementColor(this.m_headPosition, this.m_snakeHeadColor);
            if (this.m_bSmoothColoring) {
                n = this.m_tailPosition;
                for (int j = 0; j < this.m_length; ++j) {
                    ((PgElementSet)this.m_geom).setElementColor(n, this.m_smoothSnakeColor[j]);
                    n = this.m_nextEl[n];
                }
            }
            this.m_geom.update(null);
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean setFood() {
        if (this.m_length + 1 == this.m_noe) {
            this.m_foodPosition = -1;
            return false;
        }
        int n = -1;
        while (this.m_nextEl[n = Math.abs(this.m_random.nextInt()) % this.m_noe] >= 0 || n == this.m_headPosition) {
        }
        if (this.m_foodPosition > -1) {
            ((PgElementSet)this.m_geom).setElementColor(this.m_foodPosition, this.m_emptyColor);
        }
        this.m_foodPosition = n;
        ((PgElementSet)this.m_geom).setElementColor(this.m_foodPosition, this.m_foodColor);
        return true;
    }

    public void start() {
        this.m_thread = new Thread((Runnable)this, "JavaView: " + PsConfig.getMessage((int)48002));
        this.m_thread.setPriority(5);
        this.m_bAlive = true;
        this.m_thread.start();
    }

    public void stop() {
        this.m_thread = null;
    }

    public void pause() {
        this.m_bPause = true;
    }

    public void resume() {
        this.m_bPause = false;
    }

    public void run() {
        while (this.m_thread != null) {
            if (!this.m_bPause) {
                this.step();
            }
            if (!this.m_bAlive) {
                this.stop();
                return;
            }
            try {
                Thread.sleep(this.m_sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

